/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOToken;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.Logger;
import com.sun.identity.log.messageid.LogMessageProviderBase;
import com.sun.identity.log.messageid.MessageProviderFactory;
import com.sun.identity.log.s1is.LogConfigReader;
import com.sun.identity.log.spi.Debug;
import com.sun.identity.monitoring.Agent;
import com.sun.identity.monitoring.SsoServerLoggingSvcImpl;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;

public class LogManager
extends java.util.logging.LogManager {
    public static boolean isLocal = false;
    public static String HANDLER = "Handler";
    public static String FORMATTER = "Formatter";
    public static boolean isMonitoringInit = false;
    private static boolean didFirstReadConfig;
    private static final String strDEFAULT = "DEFAULT";
    private static String oldLocation;
    private static String oldLevel;
    private static String oldSecurityStatus;
    private static String oldBackend;
    private static String oldStatus;
    private static String newLocation;
    private static String newLevel;
    private static String newSecurityStatus;
    private static String newBackend;
    private static String newStatus;
    private final int OLDLOCATION = 0;
    private final int NEWLOCATION = 1;
    private final int OLDBACKEND = 2;
    private final int NEWBACKEND = 3;
    private final int OLDSECURITYSTATUS = 4;
    private final int NEWSECURITYSTATUS = 5;
    private final int OLDSTATUS = 6;
    private final int NEWSTATUS = 7;
    private final int OLDLEVEL = 8;
    private final int NEWLEVEL = 9;
    private static SsoServerLoggingSvcImpl logServiceImplForMonitoring;
    private static int loggerCount;
    private boolean securityStatus = false;
    private String[] allFields;
    private Set selectedFieldSet;
    protected Level loggingLevel = null;

    public boolean addLogger(java.util.logging.Logger logger) {
        boolean addSuccess;
        String name = logger.getName();
        if (name != null && name.length() != 0 && !name.equals("global")) {
            String rbName = logger.getResourceBundleName();
            logger = new Logger(name, rbName);
        }
        if (addSuccess = super.addLogger(logger)) {
            ++loggerCount;
        }
        return addSuccess;
    }

    public final boolean isSecure() {
        return this.securityStatus;
    }

    public final synchronized String[] getAllFields() {
        return this.allFields;
    }

    public final synchronized Set getSelectedFieldSet() {
        return this.selectedFieldSet;
    }

    private final synchronized void readAllFields() {
        String strAllFields = this.getProperty("iplanet-am-logging-allfields");
        StringTokenizer strToken = new StringTokenizer(strAllFields, ", ");
        int count = strToken.countTokens();
        String[] localAllFields = new String[count];
        count = 0;
        while (strToken.hasMoreElements()) {
            localAllFields[count++] = strToken.nextToken().trim();
        }
        this.allFields = localAllFields;
    }

    private final synchronized void readSelectedFieldSet() {
        HashSet<String> fieldSet = new HashSet<String>();
        String strSelectedFields = this.getProperty("iplanet-am-logging-logfields");
        if (strSelectedFields != null && strSelectedFields.length() != 0) {
            StringTokenizer stoken = new StringTokenizer(strSelectedFields, ", ");
            while (stoken.hasMoreElements()) {
                fieldSet.add(stoken.nextToken());
            }
        }
        this.selectedFieldSet = fieldSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void readConfiguration() throws IOException, SecurityException {
        String[] xlogData = null;
        try {
            Logger.rwLock.writeRequest();
            Class<Logger> clazz = Logger.class;
            synchronized (Logger.class) {
                Enumeration<String> loggerNames = this.getLoggerNames();
                LogManagerUtil.setupEnv();
                if (didFirstReadConfig && SystemProperties.isServerMode()) {
                    oldLocation = this.getProperty("iplanet-am-logging-location");
                    oldLevel = this.getProperty("sun-am-log-level");
                    oldSecurityStatus = this.getProperty("iplanet-am-logging-security-status");
                    oldBackend = this.getProperty("iplanet-am-logging-type");
                    oldStatus = this.getProperty("logstatus");
                }
                try {
                    if (SystemProperties.isServerMode()) {
                        LogConfigReader logConfigReader = new LogConfigReader();
                    } else {
                        super.readConfiguration();
                    }
                    didFirstReadConfig = true;
                }
                catch (Exception ex) {
                }
                finally {
                    LogManagerUtil.resetEnv();
                }
                if (isLocal) {
                    File dir;
                    this.securityStatus = false;
                    this.readAllFields();
                    this.readSelectedFieldSet();
                    if (SystemProperties.isServerMode()) {
                        newLocation = this.getProperty("iplanet-am-logging-location");
                        newLevel = this.getProperty("sun-am-log-level");
                        newSecurityStatus = this.getProperty("iplanet-am-logging-security-status");
                        newBackend = this.getProperty("iplanet-am-logging-type");
                        newStatus = this.getProperty("logstatus");
                    }
                    String[] logData = new String[]{oldLocation, newLocation, oldBackend, newBackend, oldSecurityStatus, newSecurityStatus, oldStatus, newStatus, oldLevel, newLevel};
                    if (this.getProperty("iplanet-am-logging-type").equals("DB")) {
                        HANDLER = this.getProperty("iplanet-am-logging-jdbc-handler");
                        FORMATTER = this.getProperty("iplanet-am-logging-db-formatter");
                        String driver = this.getProperty("iplanet-am-logging-db-driver");
                    } else if (this.getProperty("iplanet-am-logging-security-status").equalsIgnoreCase("ON")) {
                        this.securityStatus = true;
                        HANDLER = this.getProperty("iplanet-am-logging-secure-file-handler");
                        FORMATTER = this.getProperty("iplanet-am-logging-secure-elf-formatter");
                    } else {
                        HANDLER = this.getProperty("iplanet-am-logging-file-handler");
                        FORMATTER = this.getProperty("iplanet-am-logging-elf-formatter");
                    }
                    if (this.getProperty("iplanet-am-logging-type").equals("File") && SystemProperties.isServerMode() && newLocation != null && oldLocation != null && !oldLocation.equals(newLocation) && !(dir = new File(newLocation)).exists() && !dir.mkdirs()) {
                        Debug.error("LogManager:readConfiguration:Unable to create the new log directory. Verify that the process has necessary permissions");
                    }
                    boolean loggingInactive = this.getProperty("logstatus").equals("INACTIVE");
                    String strLogLevel = this.getProperty("sun-am-log-level");
                    try {
                        this.loggingLevel = Level.parse(strLogLevel);
                    }
                    catch (IllegalArgumentException iaex) {
                        this.loggingLevel = Level.INFO;
                        Debug.error("LogManager:readConfiguration:Log level '" + strLogLevel + "' unknown; setting to Level.INFO.");
                    }
                    if (loggingInactive) {
                        this.loggingLevel = Level.OFF;
                    }
                    xlogData = logData;
                } else {
                    HANDLER = this.getProperty("iplanet-am-logging-remote-handler");
                    if (HANDLER == null) {
                        HANDLER = "com.sun.identity.log.handlers.RemoteHandler";
                    }
                    if ((FORMATTER = this.getProperty("iplanet-am-logging-remote-formatter")) == null) {
                        FORMATTER = "com.sun.identity.log.handlers.RemoteFormatter";
                    }
                }
                Logger.resolveHostName = Boolean.valueOf(this.getProperty("resolveHostName"));
                loggerNames = this.getLoggerNames();
                while (loggerNames.hasMoreElements()) {
                    String levelProp;
                    String lvlStr;
                    String curEl = loggerNames.nextElement();
                    if (curEl.length() == 0 || curEl.length() == 0 || curEl.equals("global")) continue;
                    if (Debug.messageEnabled()) {
                        Debug.message("LogManager:readConfiguration:Processing Logger: " + curEl);
                    }
                    Logger l = (Logger)Logger.getLogger(curEl);
                    Handler[] handlers = l.getHandlers();
                    for (int i = 0; i < handlers.length; ++i) {
                        handlers[i].close();
                        l.removeHandler(handlers[i]);
                    }
                    String handlerClass = HANDLER;
                    Class<?> clz = null;
                    Class[] parameters = new Class[]{String.class};
                    Object[] parameterObjects = new Object[]{new String(l.getName())};
                    Constructor<?> cons = null;
                    Handler h = null;
                    try {
                        clz = Class.forName(handlerClass);
                    }
                    catch (Exception e) {
                        Debug.error("LogManager.readConfiguration:could not load " + handlerClass, e);
                    }
                    try {
                        cons = clz.getDeclaredConstructor(parameters);
                    }
                    catch (Exception e) {
                        Debug.error("LogManager.readConfiguration:could not instantiate" + handlerClass, e);
                    }
                    try {
                        h = (Handler)cons.newInstance(parameterObjects);
                    }
                    catch (Exception e) {
                        Debug.error("LogManager.readConfiguration:could not instantiate" + handlerClass, e);
                    }
                    String formatterClass = FORMATTER;
                    Formatter f = null;
                    try {
                        f = (Formatter)Class.forName(formatterClass).newInstance();
                    }
                    catch (Exception e) {
                        Debug.error("LogManager.readConfiguration:could not instantiate Formatter " + formatterClass, e);
                    }
                    h.setFormatter(f);
                    l.addHandler(h);
                    Level tlevel = this.loggingLevel;
                    if (this.loggingLevel != Level.OFF && (lvlStr = SystemProperties.get(levelProp = "iplanet-am-logging." + l.getName() + ".level")) != null && lvlStr.length() > 0) {
                        try {
                            tlevel = Level.parse(lvlStr);
                        }
                        catch (IllegalArgumentException iaex) {
                            // empty catch block
                        }
                    }
                    if (this.loggingLevel == null) continue;
                    l.setLevel(tlevel);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        finally {
            Logger.rwLock.writeDone();
        }
        {
            if (SystemProperties.isServerMode() && isLocal) {
                this.checkStartLogs(xlogData);
                this.updateMonitConfigForLogService();
            }
            return;
        }
    }

    private void checkStartLogs(String[] vals) {
        Enumeration<String> loggerNames = this.getLoggerNames();
        boolean loggingIsActive = false;
        boolean levelIsOff = true;
        if (vals == null) {
            return;
        }
        for (int i = 0; i <= 9; ++i) {
            if (vals[i] != null && vals[i].length() != 0) continue;
            return;
        }
        if (vals[7] != null) {
            loggingIsActive = vals[7].equals("ACTIVE");
        }
        if (vals[9] != null) {
            levelIsOff = vals[9].equals("OFF");
        }
        if (!(!loggingIsActive || vals[2].equals(vals[3]) && vals[0].equals(vals[1]) && vals[4].equals(vals[5]) && vals[6].equals(vals[7]) && vals[8].equals(vals[9]))) {
            loggerNames = this.getLoggerNames();
            String saveLevel = vals[9];
            Level level = Level.INFO;
            try {
                level = Level.parse(vals[9]);
            }
            catch (IllegalArgumentException iaex) {
                // empty catch block
            }
            while (loggerNames.hasMoreElements()) {
                vals[9] = saveLevel;
                String curEl = loggerNames.nextElement();
                if (curEl.length() == 0 || curEl.length() == 0 || curEl.equals("global")) continue;
                Logger l = (Logger)Logger.getLogger(curEl);
                Level tlevel = l.getLevel();
                if (levelIsOff) {
                    if (tlevel == Level.OFF) continue;
                    vals[9] = tlevel.toString();
                    this.logIt(l, vals, "LOG_START_CONFIG");
                    continue;
                }
                this.logIt(l, vals, "LOG_START_CONFIG");
            }
        }
    }

    private void logIt(Logger logger, String[] msg, String msgName) {
        try {
            LogMessageProviderBase provider = (LogMessageProviderBase)MessageProviderFactory.getProvider("Logging");
            SSOToken ssot = LogManagerUtil.getLoggingSSOToken();
            LogRecord lr = provider.createLogRecord(msgName, msg, ssot);
            logger.log(lr, ssot);
        }
        catch (IOException ioex) {
            Debug.error("LogManager.logIt:could not log to " + logger.getName() + ": " + ioex.getMessage());
        }
    }

    public void updateMonitConfigForLogService() {
        if (SystemProperties.isServerMode() && Agent.isRunning()) {
            if (logServiceImplForMonitoring == null) {
                logServiceImplForMonitoring = (SsoServerLoggingSvcImpl)Agent.getLoggingSvcMBean();
            }
            if (logServiceImplForMonitoring == null) {
                return;
            }
            logServiceImplForMonitoring.setSsoServerLoggingLoggers(new Integer(loggerCount));
            logServiceImplForMonitoring.setSsoServerLoggingSecure(newSecurityStatus);
            logServiceImplForMonitoring.setSsoServerLoggingTimeBuffering(this.getProperty("iplanet-am-logging-time-buffering-status"));
            logServiceImplForMonitoring.setSsoServerLoggingBufferSize(Long.valueOf(this.getProperty("iplanet-am-logging-buffer-size")));
            logServiceImplForMonitoring.setSsoServerLoggingBufferTime(Long.valueOf(this.getProperty("iplanet-am-logging-buffer-time-in-seconds")));
            logServiceImplForMonitoring.setSsoServerLoggingMaxLogSize(Long.valueOf(this.getProperty("iplanet-am-logging-max-file-size")));
            logServiceImplForMonitoring.setSsoServerLoggingNumberHistoryFiles(Long.valueOf(this.getProperty("iplanet-am-logging-num-hist-file")));
            logServiceImplForMonitoring.setSsoServerLoggingLocation(this.getProperty("iplanet-am-logging-location"));
            logServiceImplForMonitoring.setSsoServerLoggingType(this.getProperty("iplanet-am-logging-type"));
            isMonitoringInit = true;
        }
    }

    static {
        oldLocation = strDEFAULT;
        oldLevel = strDEFAULT;
        oldSecurityStatus = strDEFAULT;
        oldBackend = strDEFAULT;
        oldStatus = strDEFAULT;
        logServiceImplForMonitoring = null;
        loggerCount = 0;
    }
}

