/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tools.javadocs;

import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.standard.Standard;
import com.sun.tools.javadoc.Main;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class SupportedAPIDoclet {
    private static String SUPPORTED_ALL_API = "supported.all.api";
    private static String SUPPORTED_API = "supported.api";
    private static Set includeAll = new HashSet();

    public static void main(String[] args) {
        String name = SupportedAPIDoclet.class.getName();
        Main.execute((String)name, (String)name, (String[])args);
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) throws IOException {
        return Standard.validOptions((String[][])options, (DocErrorReporter)reporter);
    }

    public static int optionLength(String option) {
        return Standard.optionLength((String)option);
    }

    public static boolean start(RootDoc root) throws IOException {
        return Standard.start((RootDoc)((RootDoc)SupportedAPIDoclet.process(root, RootDoc.class)));
    }

    private static void setIncludeAll(Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            Doc doc;
            Object entry = array[i];
            if (!(entry instanceof Doc) || !(doc = (Doc)entry).isClass() && !doc.isInterface() || doc.tags(SUPPORTED_ALL_API).length <= 0) continue;
            includeAll.add(entry.toString());
        }
    }

    private static boolean toIncludeMe(Doc doc) {
        boolean includeMe;
        boolean bl = includeMe = doc.tags(SUPPORTED_ALL_API).length > 0 || doc.tags(SUPPORTED_API).length > 0;
        if (!includeMe) {
            String className;
            String name = doc.toString();
            int idx = name.indexOf(40);
            String string = className = idx != -1 ? name.substring(0, name.indexOf(40)) : name;
            if (!doc.isConstructor()) {
                className = className.substring(0, className.lastIndexOf(46));
            }
            includeMe = includeAll.contains(className);
        }
        return includeMe;
    }

    private static Object process(Object obj, Class expect) {
        Object[] retObj = obj;
        if (obj != null) {
            Class<?> cls = obj.getClass();
            if (cls.getName().startsWith("com.sun.")) {
                retObj = Proxy.newProxyInstance(cls.getClassLoader(), cls.getInterfaces(), (InvocationHandler)new StandardHandler(obj));
            } else if (obj instanceof Object[]) {
                Class<?> componentType = expect.getComponentType();
                Object[] array = obj;
                SupportedAPIDoclet.setIncludeAll(array);
                ArrayList<Object> list = new ArrayList<Object>(array.length);
                for (int i = 0; i < array.length; ++i) {
                    Object entry = array[i];
                    if (entry instanceof Doc && !SupportedAPIDoclet.toIncludeMe((Doc)entry)) continue;
                    list.add(SupportedAPIDoclet.process(entry, componentType));
                }
                retObj = list.toArray((Object[])Array.newInstance(componentType, list.size()));
            }
        }
        return retObj;
    }

    private static class StandardHandler
    implements InvocationHandler {
        private Object target;

        public StandardHandler(Object target) {
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName;
            if (args != null && ((methodName = method.getName()).equals("compareTo") || methodName.equals("equals") || methodName.equals("overrides") || methodName.equals("subclassOf"))) {
                args[0] = this.unwrap(args[0]);
            }
            try {
                return SupportedAPIDoclet.process(method.invoke(this.target, args), method.getReturnType());
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        private Object unwrap(Object proxy) {
            return proxy instanceof Proxy ? ((StandardHandler)Proxy.getInvocationHandler((Object)proxy)).target : proxy;
        }
    }
}

