package org.jboss.as.test.manualmode.web.websocket;

import javax.inject.Inject;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/**
 * @author rhatlapa (rhatlapa@redhat.com)
 */
@ServerEndpoint("/websocket")
public class WebSocketServerEndpoint {

    private static Set<Session> clients = Collections.synchronizedSet(new HashSet<Session>());

    @Inject
    private CdiBean bean;

    @OnMessage
    public void onMessage(String message, Session session)
            throws IOException {

        synchronized (clients) {
            // Iterate over the connected sessions
            // and broadcast the received message
            for (Session client : clients) {
                client.getBasicRemote().sendText(bean.getMessage() + message);

            }
        }
    }

    @OnOpen
    public void onOpen(Session session) {
        // Add session to the connected sessions set
        clients.add(session);
    }

    @OnClose
    public void onClose(Session session) {
        // Remove session from the connected sessions set
        clients.remove(session);
    }
}