/*
 * JBoss, a division of Red Hat
 * Copyright 2011, Red Hat Middleware, LLC, and individual
 * contributors as indicated by the @authors tag. See the
 * copyright.txt in the distribution for a full listing of
 * individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.gatein.wsrp.consumer.registry;

import org.chromattic.api.ChromatticBuilder;
import org.gatein.pc.federation.impl.FederatingPortletInvokerService;
import org.gatein.wsrp.jcr.BaseChromatticPersister;
import org.gatein.wsrp.jcr.ChromatticPersister;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

/**
 * This is essentially the same class as org.gatein.wsrp.state.consumer.ConsumerRegistryTestCase in WSRP consumer
 * module
 * tests.
 *
 * @author <a href="mailto:chris.laprun@jboss.com">Chris Laprun</a>
 * @version $Revision$
 */
public class JCRConsumerRegistryTestCase extends ConsumerRegistryTestCase
{

   private String workspaceName;

   /**
    * Incremented for each test so that we can append it to the workspace name and work with a "clean" DB for each
    * test.
    */

   @Override
   protected void setUp() throws Exception
   {
      final long random = Math.round(Math.abs(100000 * Math.random()));
      workspaceName = "/wsrp-jcr-test" + random;
      BaseChromatticPersister persister = new BaseChromatticPersister(workspaceName)
      {
         @Override
         protected void setBuilderOptions(ChromatticBuilder builder)
         {
            builder.setOptionValue(ChromatticBuilder.ROOT_NODE_PATH, workspaceName);
            builder.setOptionValue(ChromatticBuilder.ROOT_NODE_TYPE, "nt:unstructured");
            builder.setOptionValue(ChromatticBuilder.CREATE_ROOT_NODE, true);
         }
      };
      persister.initializeBuilderFor(JCRConsumerRegistry.mappingClasses);
      registry = new JCRConsumerRegistry(persister, false, workspaceName);
      registry.setFederatingPortletInvoker(new FederatingPortletInvokerService());
   }

   @Override
   protected void tearDown() throws Exception
   {
      // remove node containing consumer informations so that we can start with a clean state
      final ChromatticPersister persister = ((JCRConsumerRegistry)registry).getPersister();
      final Session session = persister.getSession().getJCRSession();
      final Node rootNode = session.getRootNode();
      final NodeIterator nodes = rootNode.getNodes();
      while (nodes.hasNext())
      {
         nodes.nextNode().remove();
      }

      // then save
      persister.closeSession(true);
   }

   @Override
   public void testStoppingShouldNotStartConsumers() throws Exception
   {
      // override to bypass this test as I couldn't find a way to make it work properly (i.e. how to inject a Mock
      // into the registry to check that start is only called once)
   }

   @Override
   protected void loadConsumersConfiguration(URL location) throws IOException
   {
      final JCRConsumerRegistry jcrConsumerRegistry = (JCRConsumerRegistry)registry;
      try
      {
         final InputStream inputStream = location.openStream();
         jcrConsumerRegistry.setConfigurationIS(inputStream);
         jcrConsumerRegistry.setLoadFromXMLIfNeeded(true);
         jcrConsumerRegistry.reloadConsumers();
      }
      finally
      {
         jcrConsumerRegistry.setLoadFromXMLIfNeeded(false);
      }
   }
}
