/*
 * JBoss, a division of Red Hat
 * Copyright 2009, Red Hat Middleware, LLC, and individual
 * contributors as indicated by the @authors tag. See the
 * copyright.txt in the distribution for a full listing of
 * individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.gatein.wsrp.producer;

import org.gatein.registration.RegistrationUtils;
import org.gatein.wsrp.WSRPPortletURL;
import org.gatein.wsrp.WSRPUtils;

/**
 * Allows to configure the level of validation that the producer performs on incoming requests.
 *
 * @author <a href="mailto:chris.laprun@jboss.com">Chris Laprun</a>
 * @version $Revision$
 */
public class WSRPValidator
{
   private static boolean strict = true;

   public static void setStrict(boolean strictMode)
   {
      strict = strictMode;
      RegistrationUtils.setStrict(strict);
      WSRPUtils.setStrict(strict);
      WSRPPortletURL.setStrict(strict);
   }

   public static boolean isStrict()
   {
      return strict;
   }
}
