<%@ taglib uri="http://java.sun.com/portlet_2_0" prefix="portlet"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ page import="org.exoplatform.webui.application.WebuiRequestContext" %>
<%@ page import="org.exoplatform.web.application.JavascriptManager" %>
<portlet:defineObjects />

<%-- The resourceBundle used to retrieve locale string values --%>
<c:set var="resourceBundle" value="${portletConfig.getResourceBundle(renderRequest.locale)}" />

<%-- Hack because web ui can't properly handle javascript modules after a full ajax page reload --%>
<%
  JavascriptManager jsMan = ((WebuiRequestContext)WebuiRequestContext.getCurrentInstance()).getJavascriptManager();
  jsMan.require("SHARED/org_gatein_jppinformation", "jppinformation").addScripts("jppinformation.init();");
%>

<div class="jppInformationPortlet">
  <div class="red_hat section">
    <div class="point highlight ">
      <img class="bullet"
           alt="${resourceBundle.getString('jpp.red_hat.logo.alttext')}"
           src="${renderRequest.contextPath}/images/Red_Hat_logo.svg"/>
        <h2 class="title">${resourceBundle.getString("jpp.portalsTheRedHatWay.title")}</h2>
        <p class="text">${resourceBundle.getString("jpp.portalsTheRedHatWay.text")}</p>
    </div>
    <div class="point">
      <img class="bullet"
           alt="${resourceBundle.getString('jpp.quickstarts.alttext')}"
           src="${renderRequest.contextPath}/images/quickstarts-bullet.svg"/>
        <p class="text">${resourceBundle.getString("jpp.quickstarts.text")}</p>
    </div>
    <div class="point">
      <img class="bullet"
          alt="${resourceBundle.getString('jpp.learnmore.alttext')}"
          src="${renderRequest.contextPath}/images/more-info-bullet.svg"/>
        <p class="text">${resourceBundle.getString("jpp.learnmore.text")}</p>
    </div>
  </div>
  <div class="community section">
    <div class="point highlight">
      <img class="bullet"
           alt="${resourceBundle.getString('jpp.forums.alttext')}"
           src="${renderRequest.contextPath}/images/forums.svg"/>
        <h2 class="title">${resourceBundle.getString("jpp.forums.title")}</h2>
        <p class="text">${resourceBundle.getString("jpp.forums.text")}</p>
    </div>
    <div class="point">
     <img class="bullet"
           alt="${resourceBundle.getString('jpp.videos.alttext')}"
           src="${renderRequest.contextPath}/images/videos-bullet.svg"/>
        <p class="text">${resourceBundle.getString("jpp.videos.text")}</p>
    </div>
  </div>
  <div class="ClearFix"></div>
</div>
