/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2012, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.portletbridge.context.exception;

import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExceptionHandlerFactory;
import javax.faces.context.FacesContext;

/**
 * @author <a href="http://community.jboss.org/people/kenfinni">Ken Finnigan</a>
 */
public class PortletExceptionHandlerFactoryImpl extends ExceptionHandlerFactory {

    private ExceptionHandlerFactory parent;

    public PortletExceptionHandlerFactoryImpl(final ExceptionHandlerFactory parent) {
        this.parent = parent;
    }

    /**
     * @see javax.faces.context.ExceptionHandlerFactory#getExceptionHandler()
     */
    @Override
    public ExceptionHandler getExceptionHandler() {
        ExceptionHandler handler = this.parent.getExceptionHandler();
        if (!PortletExceptionHandler.class.getName().equals(handler.getClass().getName())) {
            handler = new PortletExceptionHandler(handler);
        }

        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext.getPartialViewContext().isAjaxRequest()) {
            handler = new AjaxPortletExceptionHandler(handler);
        }
        return handler;
    }

}
