/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.skin;

import java.awt.Color;
import org.jvnet.substance.border.ClassicInnerBorderPainter;
import org.jvnet.substance.button.ClassicButtonShaper;
import org.jvnet.substance.color.AquaColorScheme;
import org.jvnet.substance.color.BlendBiColorScheme;
import org.jvnet.substance.color.ShiftColorScheme;
import org.jvnet.substance.color.SteelBlueColorScheme;
import org.jvnet.substance.color.TintColorScheme;
import org.jvnet.substance.painter.ClassicGradientPainter;
import org.jvnet.substance.skin.SubstanceAbstractSkin;
import org.jvnet.substance.theme.SubstanceComplexTheme;
import org.jvnet.substance.theme.SubstanceOrangeTheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.title.BrushedMetalHeaderPainter;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.watermark.SubstanceStripeWatermark;

public class OfficeBlue2007Skin
extends SubstanceAbstractSkin {
    public static final String NAME = "Office Blue 2007";

    public OfficeBlue2007Skin() {
        ShiftColorScheme shiftBlue = new ShiftColorScheme(new AquaColorScheme(), new Color(100, 150, 255), 0.3);
        SubstanceTheme activeTheme = new SubstanceOrangeTheme().saturate(0.4);
        SubstanceTheme defaultTheme = new SubstanceTheme(shiftBlue, "Aqua Blue", SubstanceTheme.ThemeKind.BRIGHT).saturate(-0.3);
        final TintColorScheme disabledScheme = new TintColorScheme(new BlendBiColorScheme(new AquaColorScheme(), new SteelBlueColorScheme(), 0.8), 0.6){
            Color foreColor;
            {
                this.foreColor = new Color(103, 164, 216);
            }

            public Color getForegroundColor() {
                return this.foreColor;
            }
        };
        SubstanceTheme disabledTheme = new SubstanceTheme(disabledScheme, "Disabled Office Blue 2007", SubstanceTheme.ThemeKind.COLD);
        SubstanceTheme activeTitleTheme = defaultTheme.saturate(-0.1);
        SubstanceComplexTheme theme = new SubstanceComplexTheme(NAME, SubstanceTheme.ThemeKind.BRIGHT, activeTheme, defaultTheme, disabledTheme, activeTitleTheme){

            public Color getLightBackgroundColor() {
                return disabledScheme.getMidColor();
            }
        };
        theme.setSelectedTabFadeStart(0.1);
        theme.setSelectedTabFadeEnd(0.3);
        this.theme = theme;
        this.shaper = new ClassicButtonShaper();
        this.watermark = new SubstanceStripeWatermark();
        this.gradientPainter = new ClassicGradientPainter();
        BrushedMetalHeaderPainter titlePainter = new BrushedMetalHeaderPainter();
        titlePainter.setPaintingSeparators(true);
        titlePainter.setTextureAlpha(0.3f);
        this.titlePainter = titlePainter;
        this.borderPainter = new ClassicInnerBorderPainter(0.8f, SubstanceConstants.ColorShiftKind.TINT);
    }

    public String getDisplayName() {
        return NAME;
    }
}

