/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.lifecycle;

import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.apache.myfaces.lifecycle.PhaseExecutor;
import org.apache.myfaces.lifecycle.ViewNotFoundException;
import org.apache.myfaces.view.facelets.ViewPoolProcessor;

class InvokeApplicationExecutor
extends PhaseExecutor {
    private ViewPoolProcessor viewPoolProcessor;
    private boolean initialized = false;

    InvokeApplicationExecutor() {
    }

    @Override
    public boolean execute(FacesContext facesContext) {
        if (facesContext.getViewRoot() == null) {
            throw new ViewNotFoundException("A view is required to execute " + facesContext.getCurrentPhaseId());
        }
        facesContext.getViewRoot().processApplication(facesContext);
        ViewPoolProcessor processor = this.getViewPoolProcessor(facesContext);
        if (processor != null) {
            processor.processDeferredNavigation(facesContext);
        }
        return false;
    }

    @Override
    public PhaseId getPhase() {
        return PhaseId.INVOKE_APPLICATION;
    }

    private ViewPoolProcessor getViewPoolProcessor(FacesContext context) {
        if (!this.initialized) {
            this.viewPoolProcessor = ViewPoolProcessor.getInstance(context);
            this.initialized = true;
        }
        return this.viewPoolProcessor;
    }
}

