/*
 * Copyright 2010 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.workbench.screens.testscenario.client;

import com.google.gwt.user.client.ui.HorizontalPanel;
import org.drools.workbench.models.testscenarios.shared.ExecutionTrace;
import org.drools.workbench.models.testscenarios.shared.Scenario;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;

public class ExpectPanel extends HorizontalPanel {

    protected final Scenario scenario;
    protected final ScenarioParentWidget parent;
    protected final ExecutionTrace previousEx;

    public ExpectPanel( ExecutionTrace previousEx,
                        final Scenario scenario,
                        final ScenarioParentWidget parent,
                        ScenarioWidgetComponentCreator scenarioWidgetComponentCreator,
                        AsyncPackageDataModelOracle oracle ) {
        this.scenario = scenario;
        this.parent = parent;
        this.previousEx = previousEx;

        add( new ExpectationButton( previousEx,
                                    scenario,
                                    parent,
                                    scenarioWidgetComponentCreator,
                                    oracle ) );
    }
}
