/*
 * Copyright 2017 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

package org.kie.server.controller.validate;

import java.util.Set;
import javax.validation.ConstraintViolation;

public class ViolationHelper {

    public static <T> String printViolations(Set<ConstraintViolation<T>> violations) {

        StringBuilder builder = new StringBuilder("[Input validation errors] ");

        for (ConstraintViolation<T> violation : violations) {
            builder.append("Property: ");
            builder.append(violation.getPropertyPath());
            builder.append(" value: ");
            builder.append(violation.getInvalidValue());
            builder.append(" error: ");
            builder.append(violation.getMessage());
            builder.append(". ");
        }

        return builder.toString();

    }

}
