/*
 * Copyright 2018 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.optaweb.employeerostering.shared.rotation.view;

import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;

import org.optaweb.employeerostering.shared.employee.Employee;
import org.optaweb.employeerostering.shared.spot.Spot;

public class RotationView {

    @NotNull
    private Integer tenantId;
    @NotNull
    private Integer rotationLength;
    @NotNull
    private List<Spot> spotList;
    @NotNull
    private List<Employee> employeeList;
    @NotNull
    private Map<Long, List<ShiftTemplateView>> spotIdToShiftTemplateViewListMap;

    public Integer getTenantId() {
        return tenantId;
    }

    public void setTenantId(Integer tenantId) {
        this.tenantId = tenantId;
    }

    public Integer getRotationLength() {
        return rotationLength;
    }

    public void setRotationLength(Integer rotationLength) {
        this.rotationLength = rotationLength;
    }

    public List<Spot> getSpotList() {
        return spotList;
    }

    public void setSpotList(List<Spot> spotList) {
        this.spotList = spotList;
    }

    public List<Employee> getEmployeeList() {
        return employeeList;
    }

    public void setEmployeeList(List<Employee> employeeList) {
        this.employeeList = employeeList;
    }

    public Map<Long, List<ShiftTemplateView>> getSpotIdToShiftTemplateViewListMap() {
        return spotIdToShiftTemplateViewListMap;
    }

    public void setSpotIdToShiftTemplateViewListMap(Map<Long, List<ShiftTemplateView>> spotIdToShiftTemplateViewListMap) {
        this.spotIdToShiftTemplateViewListMap = spotIdToShiftTemplateViewListMap;
    }
}
