package com.redhat.installer.installation.action.defaults;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.redhat.installer.installation.action.defaults.SetDefaults;

import java.util.HashMap;
import java.util.Map;

public class SetRhpamRoleDefaults extends SetDefaults {
    @Override
    public Map<String, String> getDefaultMap() {
        AutomatedInstallData adata = AutomatedInstallData.getInstance();

        boolean isBusinessCentral = adata.getRules().isConditionTrue("izpack.selected.rhpam.eap");

        if (isBusinessCentral) {
            return new HashMap<String, String>() {{
                put("role.administrator", "true");
                put("role.kieserver", "true");
                put("role.restall", "true");
                put("role.analyst", "false");
                put("role.developer", "false");
                put("role.user", "false");
                put("role.manager", "false");
                put("role.processadmin", "false");
            }};
        } else {
            return new HashMap<String, String>() {{
                put("role.administrator", "false");
                put("role.kieserver", "true");
                put("role.restall", "false");
                put("role.analyst", "false");
                put("role.developer", "false");
                put("role.user", "false");
                put("role.manager", "false");
                put("role.processadmin", "false");
            }};
        }
    }
}
