package com.redhat.installer.installation.processpanel;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.asconfiguration.processpanel.postinstallation.Jdbc;
import org.apache.commons.validator.routines.UrlValidator;

import java.io.*;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public class TomcatAddJdbcDriver {
    private static AutomatedInstallData idata;
    private static AbstractUIProcessHandler mHandler;

    public static boolean run(AbstractUIProcessHandler handler, String[] args) {
        idata = AutomatedInstallData.getInstance();
        mHandler = handler;
        List<String> jarPaths = Jdbc.readJarPaths();
        try {
            copyJarsToTomcatLib(jarPaths);
        } catch (IOException e) {
            ProcessPanelHelper.printToPanel(mHandler,
                    idata.langpack.getString("postinstall.processpanel.jarcopy.error"), true);
            ProcessPanelHelper.printToPanel(mHandler,
                    e.getMessage(), true);
            return false;
        }
        ProcessPanelHelper.printToPanel(mHandler,
                idata.langpack.getString("postinstall.processpanel.jarcopy.success"), false);
        return true;
    }

    private static void copyJarsToTomcatLib(List<String> jarPaths) throws IOException {
        UrlValidator urlValidator = new UrlValidator();
        String tomcatLibDirectory = idata.getInstallPath() + File.separator + "lib";
        Path destinationDir = Paths.get(tomcatLibDirectory);

        for (String jar : jarPaths) {
            Path destination = Paths.get(destinationDir.toString(), Paths.get(jar).getFileName().toString());
            if (urlValidator.isValid(jar)) {
                InputStream in = new BufferedInputStream(new URL(jar).openStream());
                OutputStream out = new FileOutputStream(destination.toFile());
                byte[] buffer = new byte[2048];
                int length;
                while ((length = in.read(buffer, 0, 2048)) > 0) {
                    out.write(buffer, 0, length);
                }
                in.close();
                out.close();
            } else {
                // Local file
                Files.copy(Paths.get(jar), destination);
            }
        }
    }


}
