package com.redhat.installer.tests.asconfiguration.jsf;

import com.redhat.installer.asconfiguration.jsf.VerifyJsfJars;
import com.redhat.installer.framework.mock.MockResourceBuilder;
import com.redhat.installer.framework.testers.DataValidatorTester;
import com.redhat.installer.tests.TestUtils;
import org.junit.Before;
import org.junit.Test;

import static junit.framework.TestCase.assertEquals;

/**
 * Created by thauser on 9/30/16.
 */
public class VerifyJsfJarsTest extends AbstractVerifyJsfValidatorTest {
    @Before
    public void setUp() throws Exception {
        idata.langpack = TestUtils.createMockLangpack(tempFolder, "JBossJsfSetupPanel.error.JarError", "jsf.error.invalid.impl", "jsf.error.invalid.api");
        dv = new VerifyJsfJars();
    }

    @Test
    public void testValidApiValidImpl() {
        assertStatusOk();
    }

    @Test
    public void testInvalidApiValidImpl() {
        idata.setVariable(apiPathVar, tempFolder.toString() + "/gibberish");
        assertStatusError();
        assertEquals(String.format(idata.langpack.getString("JBossJsfSetupPanel.error.JarError"), tempFolder.toString() + "/gibberish"), dv.getFormattedMessage());
    }

    @Test
    public void testValidApiInvalidImpl() {
        idata.setVariable(implPathVar, tempFolder.toString() + "/gibberish");
        assertStatusError();
        assertEquals(String.format(idata.langpack.getString("JBossJsfSetupPanel.error.JarError"), tempFolder.toString() + "/gibberish"), dv.getFormattedMessage());
    }

    @Test
    public void testInvalidApiInvalidImpl() {
        idata.setVariable(apiPathVar, tempFolder.toString() + "/gibberish");
        idata.setVariable(implPathVar, tempFolder.toString() + "/gibberish");
        assertStatusError();
        assertEquals(String.format(idata.langpack.getString("JBossJsfSetupPanel.error.JarError"), tempFolder.toString() + "/gibberish"), dv.getFormattedMessage());
    }
}
