package com.izforge.izpack.panels;

import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.util.Debug;

import javax.swing.*;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;

/**
 * Created by thauser on 5/5/15.
 */
public class DirUrlInputField extends FileInputField {
    private final String[] supportedProtocols = new String[]{"http", "https", "ftp", "file"};

    public DirUrlInputField(IzPanel parent, InstallData data, boolean directory, String set, int size, List<ValidatorContainer> validatorConfig, String fileExt, String fileExtDesc, boolean mustExist) {
        super(parent, data, directory, set, size, validatorConfig, fileExt, fileExtDesc, mustExist);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == browseBtn) {
            String initialPath = data.getVariable("USER_HOME");

            if (filetxt.getText() != null && !isSupportedProtocol(filetxt.getText())) {
                initialPath = filetxt.getText();
            }
            JFileChooser fileChooser = new JFileChooser(initialPath);
            prepareFileChooser(fileChooser);

            if (fileChooser.showOpenDialog(parentFrame) == JFileChooser.APPROVE_OPTION) {
                String selectedPath = fileChooser.getSelectedFile().getAbsolutePath();
                filetxt.setText(selectedPath);
                Debug.trace("Setting dir url input field directory to: " + selectedPath);
            }
        }
    }

    public String getSelectedValue() {
        String text = filetxt.getText();
        if (isSupportedProtocol(text)) {
            return text;
        } else {
            File result = new File(text);
            return result.getAbsolutePath();
        }
    }

    private boolean isSupportedProtocol(String text) {
        for (String protocol : supportedProtocols) {
            if (text.startsWith(protocol))
                return true;
        }
        return false;
    }

    @Override
    protected void prepareFileChooser(JFileChooser fileChooser) {
        super.prepareFileChooser(fileChooser);
        fileChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
    }

    @Override
    public boolean validateField() {
        boolean result;
        String input = filetxt.getText();
        if (allowEmpty && input == null || input.isEmpty()) {
            result = true;
        } else {
            if (isSupportedProtocol(input)) {
                result = super.runValidators(input);
            } else {
                result = super.validateField();
            }
        }
        ButtonFactory.clearButtonMnemonics();
        return result;
    }
}
