package com.izforge.izpack.util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by eunderhi on 11/06/15.
 * Utility class that maps Validator class
 * names to their corresponding parameters.
 */
public class ValidatorMap implements Serializable{

    private List<String> classNames = new ArrayList<String>();
    private List<Map<String, String>> params = new ArrayList<Map<String, String>>();

    public Map<String, String> getParams(int index) {
        return params.get(index);
    }
    public String getName(int index) {
        return classNames.get(index);
    }
    public void put(String className, Map<String, String> param) {
        params.add(param);
        classNames.add(className);
    }
    public boolean isEmpty() {
        return classNames.isEmpty();
    }
    public int size() {
       return classNames.size();
    }
}
