/*
 * Copyright 2018 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.forms.editor.backend.service.impl.helpers;

import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.kie.workbench.common.forms.editor.type.FormResourceTypeDefinition;
import org.kie.workbench.common.forms.model.FormDefinition;
import org.kie.workbench.common.forms.services.backend.serialization.FormDefinitionSerializer;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.io.IOService;

public class AbstractFormDefinitionHelper {

    private IOService ioService;
    private FormDefinitionSerializer serializer;
    private CommentedOptionFactory commentedOptionFactory;

    public AbstractFormDefinitionHelper(FormDefinitionSerializer serializer, IOService ioService, CommentedOptionFactory commentedOptionFactory) {
        this.serializer = serializer;
        this.ioService = ioService;
        this.commentedOptionFactory = commentedOptionFactory;
    }

    public boolean supports(Path path) {
        return path.getFileName().endsWith("." + FormResourceTypeDefinition.EXTENSION);
    }

    public void postProcess(Path source, Path destination) {
        org.uberfire.java.nio.file.Path destinationNioPath = Paths.convert(destination);

        FormDefinition formDefinition = serializer.deserialize(ioService.readAllString(destinationNioPath));

        processFormDefinition(formDefinition, destination);

        ioService.write(destinationNioPath,
                        serializer.serialize(formDefinition),
                        commentedOptionFactory.makeCommentedOption("Updating form [" + destination.toURI() + "]."));
    }

    protected void processFormDefinition(FormDefinition formDefinition, Path formPath) {
        String newName = formPath.getFileName();

        newName = newName.substring(0, newName.lastIndexOf("."));

        formDefinition.setName(newName);
    }
}
