/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.agriculture.dag.agorha.util;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public class DureeComponent
implements Serializable,
Comparable<DureeComponent> {
    private static final long serialVersionUID = 7779852153041093879L;
    public static final int DUREE_COMPTABLE = 0;
    public static final int DUREE_CALENDAIRE = 1;
    public static final int NB_JOURS_ANNEE_COMPABLE = 360;
    private static final String DUREE_NULLE = "000000";
    public static final String SOUS_DUREE_NULLE = "00";
    private static final String LABELLE_ANNEE = "a";
    private static final String LABELLE_MOIS = "m";
    private static final String LABELLE_JOUR = "j";
    private static final String LABELLE_ANNEE_COMPLET = "an(s)";
    private static final String LABELLE_MOIS_COMPLET = "mois";
    private static final String LABELLE_JOUR_COMPLET = "jour(s)";
    private static final String LABELLE_ANNEE_COMPLET_SINGULIER = "an";
    private static final String LABELLE_JOUR_COMPLET_SINGULIER = "jour";
    private static final String ESPACE = " ";
    public static final String TYPE_COMPARAISON_ANNEE = "A";
    public static final String TYPE_COMPARAISON_MOIS = "M";
    public static final String TYPE_COMPARAISON_JOUR = "J";
    private String duree;
    private boolean dureeNulle = false;

    public static DureeComponent getDureeCumulee(DureeComponent[] durees) {
        DureeComponent cumulDuree = new DureeComponent(DUREE_NULLE);
        DureeComponent[] dureeComponentArray = durees;
        int n = durees.length;
        int n2 = 0;
        while (n2 < n) {
            DureeComponent duree = dureeComponentArray[n2];
            cumulDuree = DureeComponent.additionDuree(cumulDuree, duree);
            ++n2;
        }
        return cumulDuree;
    }

    public static DureeComponent additionDuree(DureeComponent duree1, DureeComponent duree2) {
        if (duree1 == null) {
            return duree2;
        }
        if (duree2 == null) {
            return duree1;
        }
        if (duree1 == null && duree2 == null) {
            return null;
        }
        int jour1 = Integer.parseInt(duree1.getJour());
        int jour2 = Integer.parseInt(duree2.getJour());
        int jourCumul = (jour1 + jour2) % 30;
        int moisCumulTotal = (jour1 + jour2) / 30;
        moisCumulTotal += Integer.parseInt(duree1.getMois());
        int moisCumul = (moisCumulTotal += Integer.parseInt(duree2.getMois())) % 12;
        int anneeCumul = moisCumulTotal / 12;
        anneeCumul += Integer.parseInt(duree1.getAnnee());
        return new DureeComponent(String.format("%1$02d%2$02d%3$02d", anneeCumul += Integer.parseInt(duree2.getAnnee()), moisCumul, jourCumul));
    }

    public static String getAnnee(String duree) {
        if (duree.length() == 6) {
            return duree.substring(0, 2);
        }
        return SOUS_DUREE_NULLE;
    }

    public static String getMois(String duree) {
        if (duree.length() == 6) {
            return duree.substring(2, 4);
        }
        return SOUS_DUREE_NULLE;
    }

    public static String getJour(String duree) {
        if (duree.length() == 6) {
            return duree.substring(4, 6);
        }
        return SOUS_DUREE_NULLE;
    }

    public DureeComponent() {
        this.duree = DUREE_NULLE;
    }

    public DureeComponent(String duree) {
        if (duree == null || duree.length() != 6) {
            this.dureeNulle = true;
            this.duree = DUREE_NULLE;
        } else {
            this.duree = duree;
        }
    }

    public DureeComponent(Date dateDebut, Date dateFin) {
        this(dateDebut, dateFin, 1);
    }

    public DureeComponent(Date dateDebut, Date dateFin, int typeDuree) {
        if (dateDebut == null || dateFin == null) {
            this.dureeNulle = true;
            this.duree = DUREE_NULLE;
        } else if (typeDuree == 0) {
            if (dateDebut.after(dateFin)) {
                this.dureeNulle = true;
                this.duree = DUREE_NULLE;
            } else {
                this.duree = this.getDureeComptableEntreDate(dateDebut, dateFin);
            }
        } else if (typeDuree == 1) {
            if (dateDebut.after(dateFin)) {
                this.dureeNulle = true;
                this.duree = DUREE_NULLE;
            } else {
                this.duree = this.getDureeCalendaireEntreDate(dateDebut, dateFin);
            }
        }
    }

    public DureeComponent(Integer nombreJours) {
        if (nombreJours == null) {
            throw new IllegalArgumentException("La duree n'accepte pas les valeurs null");
        }
        int dureeAnnee = Math.round(nombreJours / 360);
        int dureeMois = Math.round(nombreJours % 360 / 30);
        int dureeJour = nombreJours % 360 % 30;
        this.duree = String.format("%02d%02d%02d", dureeAnnee, dureeMois, dureeJour);
    }

    public int getNbreJours() {
        return Integer.valueOf(this.getAnnee()) * 360 + Integer.valueOf(this.getMois()) * 30 + Integer.valueOf(this.getJour());
    }

    public int getNbreMois() {
        return Integer.valueOf(this.getAnnee()) * 12 + Integer.valueOf(this.getMois());
    }

    public String getDuree() {
        if (this.duree != null && this.duree.length() == 6) {
            return this.duree;
        }
        return DUREE_NULLE;
    }

    public void setDuree(String duree) {
        if (duree != null && duree.length() != 6) {
            this.dureeNulle = true;
            this.duree = DUREE_NULLE;
        } else {
            this.duree = duree;
        }
    }

    public String getAnnee() {
        if (this.duree != null && this.duree.length() == 6) {
            return this.duree.substring(0, 2);
        }
        return SOUS_DUREE_NULLE;
    }

    public void setAnnee(String annee) {
        this.duree = String.valueOf(this.getSousDureeValide(annee)) + this.duree.substring(2, 6);
    }

    private String getSousDureeValide(String sousDuree) {
        if (this.duree == null || this.duree.length() != 6 || sousDuree.length() != 2 || !sousDuree.matches("[0-9.]*")) {
            sousDuree = SOUS_DUREE_NULLE;
        }
        return sousDuree;
    }

    public String getMois() {
        if (this.duree != null && this.duree.length() == 6) {
            return this.duree.substring(2, 4);
        }
        return SOUS_DUREE_NULLE;
    }

    public void setMois(String mois) {
        this.duree = String.valueOf(this.duree.substring(0, 2)) + this.getSousDureeValide(mois) + this.duree.substring(4, 6);
    }

    public String getJour() {
        if (this.duree != null && this.duree.length() == 6) {
            return this.duree.substring(4, 6);
        }
        return SOUS_DUREE_NULLE;
    }

    public void setJour(String jour) {
        this.duree = String.valueOf(this.duree.substring(0, 4)) + this.getSousDureeValide(jour);
    }

    public String getDureeCalendaireEntreDate(Date dateDebut, Date dateFin) {
        Calendar calendar1 = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar1.setTime(dateDebut);
        calendar2.setTime(dateFin);
        int jourDebut = calendar1.get(5);
        int moisDebut = calendar1.get(2);
        int anneeDebut = calendar1.get(1);
        int jourFin = calendar2.get(5);
        int moisFin = calendar2.get(2);
        int anneeFin = calendar2.get(1);
        int dureeJour = jourFin - jourDebut + 1;
        int dureeMois = moisFin - moisDebut;
        int dureeAnnee = anneeFin - anneeDebut;
        if (moisDebut > moisFin) {
            --dureeAnnee;
            dureeMois = 12 - (moisDebut - moisFin);
        }
        if (jourDebut > jourFin) {
            dureeMois = dureeMois != 0 ? --dureeMois : 11;
            dureeJour = this.getMaxDayOfMonth(moisDebut) - (jourDebut - jourFin);
        }
        return String.format("%02d%02d%02d", dureeAnnee, dureeMois, dureeJour);
    }

    public int getMaxDayOfMonth(int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, month);
        calendar.set(5, 1);
        calendar.add(5, -1);
        return calendar.get(5);
    }

    private String getDureeComptableEntreDate(Date dateDebut, Date dateFin) {
        Calendar calendar1 = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar1.setTime(dateDebut);
        calendar2.setTime(dateFin);
        int jourDebut = calendar1.get(5);
        int moisDebut = calendar1.get(2);
        int anneeDebut = calendar1.get(1);
        int jourFin = calendar2.get(5);
        int moisFin = calendar2.get(2);
        int anneeFin = calendar2.get(1);
        if (jourDebut > 30) {
            jourFin = 30;
        }
        if (jourFin > 30) {
            jourFin = 30;
        }
        int dureeJour = jourFin - jourDebut + 1;
        int dureeMois = moisFin - moisDebut;
        int dureeAnnee = anneeFin - anneeDebut;
        if (dureeJour == 30) {
            dureeJour = 0;
            ++dureeMois;
        }
        if (dureeJour < 0) {
            dureeJour += 30;
            --dureeMois;
        }
        if (moisFin + 1 < moisDebut || moisFin == moisDebut && jourFin + 1 < jourDebut) {
            dureeMois += 12;
            --dureeAnnee;
        }
        return String.format("%02d%02d%02d", dureeAnnee, dureeMois, dureeJour);
    }

    public boolean isNull() {
        return this.dureeNulle;
    }

    public void add(DureeComponent duree) {
        this.setDuree(DureeComponent.additionDuree(this, duree).getDuree());
    }

    public void add(int nbJour) {
        DureeComponent dureeAjoutee = new DureeComponent();
        dureeAjoutee.setAnnee(String.format("%1$02d", nbJour / 360));
        dureeAjoutee.setMois(String.format("%1$02d", Integer.valueOf(nbJour % 360) / 30));
        dureeAjoutee.setJour(String.format("%1$02d", Integer.valueOf(nbJour % 360) % 30));
        this.setDuree(DureeComponent.additionDuree(this, dureeAjoutee).getDuree());
    }

    @Override
    public int compareTo(DureeComponent dureeComponent) {
        Integer duree = Integer.valueOf(this.duree);
        Integer paramDuree = Integer.valueOf(dureeComponent.getDuree());
        return duree.compareTo(paramDuree);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getAnnee());
        stringBuilder.append(LABELLE_ANNEE);
        stringBuilder.append(this.getMois());
        stringBuilder.append(LABELLE_MOIS);
        stringBuilder.append(this.getJour());
        stringBuilder.append(LABELLE_JOUR);
        return stringBuilder.toString();
    }

    public String getLibelleComplet() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getAnnee());
        stringBuilder.append(ESPACE);
        stringBuilder.append(LABELLE_ANNEE_COMPLET);
        stringBuilder.append(ESPACE);
        stringBuilder.append(this.getMois());
        stringBuilder.append(ESPACE);
        stringBuilder.append(LABELLE_MOIS_COMPLET);
        stringBuilder.append(ESPACE);
        stringBuilder.append(this.getJour());
        stringBuilder.append(ESPACE);
        stringBuilder.append(LABELLE_JOUR_COMPLET);
        return stringBuilder.toString();
    }

    public boolean isBetween(Integer minValue, Integer maxValue, Integer value) {
        return value >= minValue && value <= maxValue;
    }

    public static Date calculDateFinFromDateDebutEtDuree(Date dateDebut, int duree) {
        if (dateDebut == null || duree < 0) {
            return null;
        }
        if (duree == 0) {
            return dateDebut;
        }
        int dureeAnnee = Math.round(duree / 360);
        int dureeMois = Math.round(duree % 360 / 30);
        int dureeJour = duree % 360 % 30;
        Calendar calDebut = Calendar.getInstance();
        Calendar calFin = Calendar.getInstance();
        calDebut.setTime(dateDebut);
        calFin.setTime(dateDebut);
        int jourDebut = calDebut.get(5);
        int jourDateFin = jourDebut + dureeJour;
        calFin.add(1, dureeAnnee);
        if (jourDateFin >= 31) {
            calFin.add(2, dureeMois + 1);
            jourDateFin -= 30;
        } else {
            calFin.add(2, dureeMois);
        }
        int maxJourDuMois = calFin.getActualMaximum(5);
        if (maxJourDuMois < jourDateFin) {
            calFin.set(5, maxJourDuMois);
        } else {
            calFin.set(5, jourDateFin);
        }
        return calFin.getTime();
    }

    public boolean isDureeNull() {
        return this.duree == null || DUREE_NULLE.equals(this.duree);
    }

    public static DureeComponent convertDureeEnDureeComponent(Integer duree) {
        if (duree == null) {
            return new DureeComponent();
        }
        int dureeAnnee = Math.round(duree / 360);
        int dureeMois = Math.round(duree % 360 / 30);
        int dureeJour = duree % 360 % 30;
        return new DureeComponent(String.format("%02d%02d%02d", dureeAnnee, dureeMois, dureeJour));
    }

    public static boolean isDureePrevueNull(DureeComponent dureePrevue) {
        return dureePrevue.getAnnee().equals(SOUS_DUREE_NULLE) && dureePrevue.getJour().equals(SOUS_DUREE_NULLE) && dureePrevue.getMois().equals(SOUS_DUREE_NULLE);
    }

    public static boolean isRG25091ControleDureePrevuePeriode(DureeComponent dureePrevuePeriode) {
        return DureeComponent.isBetween(0, 30, dureePrevuePeriode.getJour()) && DureeComponent.isBetween(0, 11, dureePrevuePeriode.getMois()) && Integer.valueOf(dureePrevuePeriode.getAnnee()) >= 0;
    }

    private static boolean isBetween(Integer minValue, Integer maxValue, String value) {
        return Integer.valueOf(value) >= minValue && Integer.valueOf(value) <= maxValue;
    }

    public static Date getDateEtape1(DureeComponent dureeComponent, Date dateRef) {
        int jours = Integer.parseInt(dureeComponent.getJour());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateRef);
        calendar.add(5, jours);
        return calendar.getTime();
    }

    public static Date getDateEtape2(DureeComponent dureeComponent, Date dateRef, Date dateCible) {
        int mois = Integer.parseInt(dureeComponent.getMois());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateRef);
        calendar.add(2, mois);
        return calendar.getTime();
    }

    public static Date getDateEtape3(DureeComponent dureeComponent, Date dateRef) {
        int annee = Integer.parseInt(dureeComponent.getAnnee());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateRef);
        calendar.add(1, annee);
        return calendar.getTime();
    }

    public static Date getDateJourMoinUnJour(Date dateRef) {
        if (dateRef == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateRef);
        int nbJour = calendar.get(5) - 1;
        calendar.set(5, nbJour);
        return calendar.getTime();
    }

    public static Date getDatePlusUnJour(Date dateRef) {
        if (dateRef == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateRef);
        int nbJour = calendar.get(5) + 1;
        calendar.set(5, nbJour);
        return calendar.getTime();
    }

    public boolean isDureeBorneParTypeCalendaire(Integer minValue, Integer maxValue, String type) {
        if (TYPE_COMPARAISON_ANNEE.equals(type)) {
            return this.isBetween(minValue * 360, maxValue * 360, this.getNbreJours());
        }
        if (TYPE_COMPARAISON_MOIS.equals(type)) {
            return this.isBetween(minValue * 30, maxValue * 30, this.getNbreJours());
        }
        if (TYPE_COMPARAISON_JOUR.equals(type)) {
            return this.isBetween(minValue, maxValue, this.getNbreJours());
        }
        return false;
    }

    public String getDureePrevuePourEdition() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!SOUS_DUREE_NULLE.equals(this.getAnnee())) {
            stringBuilder.append(ESPACE);
            stringBuilder.append(this.getAnnee());
            if (Integer.parseInt(this.getAnnee()) > 1) {
                stringBuilder.append(ESPACE);
                stringBuilder.append(LABELLE_ANNEE_COMPLET);
            } else {
                stringBuilder.append(ESPACE);
                stringBuilder.append(LABELLE_ANNEE_COMPLET_SINGULIER);
            }
        }
        if (!SOUS_DUREE_NULLE.equals(this.getMois())) {
            stringBuilder.append(ESPACE);
            stringBuilder.append(this.getMois());
            stringBuilder.append(ESPACE);
            stringBuilder.append(LABELLE_MOIS_COMPLET);
        }
        if (!SOUS_DUREE_NULLE.equals(this.getJour())) {
            stringBuilder.append(ESPACE);
            stringBuilder.append(this.getJour());
            if (Integer.parseInt(this.getJour()) > 1) {
                stringBuilder.append(ESPACE);
                stringBuilder.append(LABELLE_JOUR_COMPLET);
            } else {
                stringBuilder.append(ESPACE);
                stringBuilder.append(LABELLE_JOUR_COMPLET_SINGULIER);
            }
        }
        stringBuilder.append(ESPACE);
        return stringBuilder.toString();
    }

    public boolean isEmpty(DureeComponent duree) {
        return duree.getAnnee().equals(SOUS_DUREE_NULLE) && duree.getJour().equals(SOUS_DUREE_NULLE) && duree.getMois().equals(SOUS_DUREE_NULLE) || (duree.getAnnee().isEmpty() || duree.getAnnee() == null) && (duree.getAnnee().isEmpty() || duree.getAnnee() == null) && (duree.getAnnee().isEmpty() || duree.getAnnee() == null);
    }

    public boolean isNegative(DureeComponent duree) {
        if (duree != null) {
            return Integer.valueOf(duree.getAnnee()) < 0 || Integer.valueOf(duree.getMois()) < 0 || Integer.valueOf(duree.getJour()) < 0;
        }
        return true;
    }
}

