/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TagHandler;
import org.apache.myfaces.view.facelets.AbstractFaceletContext;
import org.apache.myfaces.view.facelets.TemplateClient;
import org.apache.myfaces.view.facelets.el.VariableMapperWrapper;
import org.apache.myfaces.view.facelets.tag.ComponentContainerHandler;
import org.apache.myfaces.view.facelets.tag.TagHandlerUtils;
import org.apache.myfaces.view.facelets.tag.ui.DefineHandler;

final class LegacyUserTagHandler
extends TagHandler
implements TemplateClient,
ComponentContainerHandler {
    protected final TagAttribute[] _vars;
    protected final URL _location;
    protected final Map<String, DefineHandler> _handlers;

    public LegacyUserTagHandler(TagConfig config, URL location) {
        super(config);
        this._vars = this.tag.getAttributes().getAll();
        this._location = location;
        Collection<DefineHandler> defines = TagHandlerUtils.findNextByType(this.nextHandler, DefineHandler.class);
        if (defines.isEmpty()) {
            this._handlers = null;
        } else {
            this._handlers = new HashMap<String, DefineHandler>();
            for (DefineHandler handler : defines) {
                this._handlers.put(handler.getName(), handler);
            }
        }
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        VariableMapper orig = ctx.getVariableMapper();
        AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
        try {
            String[] names = null;
            ValueExpression[] values = null;
            if (this._vars.length > 0) {
                names = new String[this._vars.length];
                values = new ValueExpression[this._vars.length];
                for (int i = 0; i < this._vars.length; ++i) {
                    names[i] = this._vars[i].getLocalName();
                    values[i] = this._vars[i].getValueExpression(ctx, Object.class);
                }
            }
            actx.pushClient(this);
            if (this._vars.length > 0) {
                VariableMapperWrapper varMapper = new VariableMapperWrapper(orig);
                for (int i = 0; i < this._vars.length; ++i) {
                    varMapper.setVariable(names[i], values[i]);
                }
                ctx.setVariableMapper((VariableMapper)varMapper);
            }
            actx.getTemplateContext().setAllowCacheELExpressions(false);
            ctx.includeFacelet(parent, this._location);
        }
        catch (FileNotFoundException e) {
            throw new TagException(this.tag, e.getMessage());
        }
        finally {
            actx.popClient(this);
            ctx.setVariableMapper(orig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean apply(FaceletContext ctx, UIComponent parent, String name) throws IOException, FacesException, FaceletException, ELException {
        if (name != null) {
            if (this._handlers == null) {
                return false;
            }
            DefineHandler handler = this._handlers.get(name);
            if (handler != null) {
                AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
                handler.applyDefinition(ctx, parent);
                return true;
            }
            return false;
        }
        AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
        this.nextHandler.apply(ctx, parent);
        return true;
    }
}

