package com.izforge.izpack.util;

import java.io.File;

import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;


/**
 * This class represents a simple validator to test if a file exists.
 * 
 */
public class PathValidator implements Validator
{

    /**
     * PathValidator
     * Validates the given path
     *
     * @param client the client object using the services of this validator.
     * @return <code>true</code> if the validation passes, otherwise <code>false</code>.
     */
    public Status validate(ProcessingClient client)
    {
        
        String value = client.getFieldContents(0);
        Status failureStatus = Status.ERROR;

        if (client.hasParams() && Boolean.parseBoolean(client.getValidatorParams().get(WARNING_PARAM)))
            failureStatus = Status.WARNING;
        if ((value == null) || (value.length() == 0))
        {
            return failureStatus;
        }
        boolean validationResult = pathMatches(value);
        if (!validationResult)
            return failureStatus;
        return Status.OK;
    }
    
    
    private boolean pathMatches(String path)
    {
        if (path != null)
        { 
            File file = new File(path);
            if ( file.isDirectory() )
            {
                return true;
            }
        }
        return false;
    }
}
