package org.jboss.brmsbpmsuite.patching.phase;

import org.jboss.brmsbpmsuite.patching.client.Patcher;

import java.io.File;
import java.io.IOException;

public class BasePatchingPhaseRunner implements PatchingPhaseRunner {
    private final Patcher patcher;
    private final File backupDir;

    public BasePatchingPhaseRunner(Patcher patcher, File backupDir) {
        this.patcher = patcher;
        this.backupDir = backupDir;
    }

    @Override
    public void run(PatchingPhase phase) throws IOException {
        switch (phase) {
            case APPLY:
                patcher.apply();
                break;
            case BACKUP:
                patcher.backup(backupDir);
                break;
        }
    }
}
