#!/usr/bin/env sh
set -e
# Shrinks the patch by removing the duplicated files.

# $1: location of 'updates' dir
if [ "x" == "x$1" ]; then
    echo "Please specify the 'updates' dir as the first argument!"
    exit 1
fi
UPDATES_DIR=$(readlink -f "$1")
echo "Working with UPDATES_DIR=$UPDATES_DIR"

NEW_CONTENT_DIR="$UPDATES_DIR/new-content"
rm -rf "$NEW_CONTENT_DIR"
mkdir  "$NEW_CONTENT_DIR"

# we don't want spaces as separators for the result `find ...` as that break paths that contain spaces
ORIG_IFS="$IFS"
IFS=$(echo -en "\n\b")

for DISTRO in `ls "$UPDATES_DIR"`; do
    if [ "$DISTRO" == "new-content" ]; then
        continue
    fi
    echo "Shrinking $DISTRO distribution..."
    NEW_CONTENT_FILE="$UPDATES_DIR/$DISTRO/new-content.txt"
    rm -rf "$NEW_CONTENT_FILE"
    OLD_PWD=`pwd`
    cd "$UPDATES_DIR/$DISTRO/new-content"
    for FILE in `find . -type f | sed "s|^\./||"`; do
        FILENAME=$(basename "$FILE")
        MD5SUM=`md5sum "${FILE}" | awk '{print $1}'`
        cp -n "$FILE" "$NEW_CONTENT_DIR/$FILENAME.$MD5SUM"
        echo "$FILE=$FILENAME.$MD5SUM" >> "$NEW_CONTENT_FILE"
    done
    cat "$NEW_CONTENT_FILE" | sort > "$NEW_CONTENT_FILE.sorted"
    mv "$NEW_CONTENT_FILE.sorted" "$NEW_CONTENT_FILE"
    # remove the distro specific new-content dir
    rm -rf cd "$UPDATES_DIR/$DISTRO/new-content"
    cd "$OLD_PWD"
done
IFS="$ORIG_IFS"
