package com.redhat.installer.asconfiguration.jsf;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.installer.SetWarningDefault;
import com.redhat.installer.asconfiguration.utils.JarUtils;
import java.io.IOException;
import java.util.jar.JarFile;

/**
 * Created by jjavier on 21/06/16.
 */
public class VerifyJsfVersionValidator implements DataValidator, SetWarningDefault{

    private String formattedMessage;

    @Override
    public Status validateData(AutomatedInstallData adata) {
        String combinedMsg = adata.getVariable("jsf.validator.combined.msg");
        String currentTurn = adata.getVariable("jsf.to.validate.version");
        String jarTmpPath = adata.getVariable(currentTurn+".tmp");
        String jarPath = jarTmpPath == null? adata.getVariable(currentTurn) : jarTmpPath;

        if (currentTurn.contains("api")) {
            adata.setVariable("jsf.to.validate.version", "jsfimpl.input");
        } else {
            adata.setVariable("jsf.to.validate.version", "jsfapi.input");
        }

        String adataVer = adata.getVariable("jsf.version");

        if(jarPath == null||adataVer == null){

            setFormattedMessage(adata.langpack.getString("jsf.error.missing.xml.info"));
            return Status.ERROR;
        }

        try (JarFile jar = JarUtils.getJarFromPath(jarPath)) {
            String ver = getVersionFromPomAndManifest(jar);

            String cleanedVer = JsfUtils.cleanedVer(ver);
            String cleanedAdataVer = JsfUtils.cleanedVer(adataVer);

            String twoDigitVer = cleanedVer.length() > 2  ? cleanedVer.substring(0,3) : "";
            String twoDigitAdataVer =cleanedAdataVer.length() > 2  ?cleanedAdataVer.substring(0,3) : "" ;

            String threeDigitVer =cleanedVer.length() > 4  ?cleanedVer.substring(0,5) : "";
            String threeDigitAdataVer =cleanedAdataVer.length() > 4  ?cleanedAdataVer.substring(0,5) : "" ;

            if(ver.equals("")) {
                if (adataVer.equals("")) {
                    setFormattedMessage(adata.langpack.getString("empty.fields.version"));
                    adata.setVariable("jsf.validator.combined.msg", "");
                    return Status.ERROR;
                }
                combinedMsg += (String.format(adata.langpack.getString("JBossJsfSetupPanel.error.NoPom"), jarPath))+"\n";
                adata.setVariable("jsf.validator.combined.msg", combinedMsg);
                return Status.OK;
            }

            if(cleanedVer.equals("")) {
                setFormattedMessage(String.format(adata.langpack.getString("jsf.version.not.supported"), ver));
                adata.setVariable("jsf.validator.combined.msg", "");
                return Status.ERROR;
            }

            //check both a.b forms
            //ver cannot be empty at this point
            if(!(twoDigitVer.equals(twoDigitAdataVer))){
                if (adataVer.equals("")) {
                    adata.setVariable("jsf.version", ver);
                    setFormattedMessage(String.format(adata.langpack.getString("JBossJsfSetupPanel.setversion"), ver));
                    return Status.WARNING;
                }else {
                    combinedMsg +=(String.format(adata.langpack.getString("JBossJsfSetupPanel.error.VersionMatch"), adataVer, ver, jarPath))+"\n";
                    adata.setVariable("jsf.validator.combined.msg", combinedMsg);
                    return Status.OK;
                }
            }

            //if both are in the form a.b.c, compare
            if (!threeDigitAdataVer.equals("") && !threeDigitVer.equals("") && !threeDigitAdataVer.equals(threeDigitVer)) {
                combinedMsg += (String.format(adata.langpack.getString("JBossJsfSetupPanel.error.VersionMatch"), adataVer, ver, jarPath)) + "\n";
                adata.setVariable("jsf.validator.combined.msg", combinedMsg);
                return Status.OK;
            }
        } catch (IOException e) {
            setFormattedMessage(String.format(adata.langpack.getString("JBossJsfSetupPanel.error.JarError"), jarPath));
            adata.setVariable("jsf.validator.combined.msg", "");
            return Status.ERROR;
        }
        return Status.OK;
    }

    private String getVersionFromPomAndManifest(JarFile jar) throws IOException {
        String version;
        version = JarUtils.getResourceFromJar(jar, JarUtils.POM_PATH, "version");
        version = version.equals("") ? JarUtils.getResourceFromJar(jar, JarUtils.MANIFEST_PATH, "Bundle-Version"): version;
        return version;
    }

    @Override
    public String getErrorMessageId() {
        return null;
    }

    @Override
    public String getWarningMessageId() {
        return null;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    public boolean warningDefault() {
        return true;
    }
    @Override
    public String getFormattedMessage() {
        return formattedMessage;
    }

    public void setFormattedMessage(String message) {
        formattedMessage = message;
    }
}
