/*
 * Copyright 2019 Red Hat, Inc, and individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wildfly.swarm.microprofile.restclient.headers;

import org.eclipse.microprofile.rest.client.RestClientBuilder;

import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import java.net.URI;
import java.util.Map;

/**
 * A resource that consumes a header and should pass it to
 *
 * @author Michal Szynkiewicz, michal.l.szynkiewicz@gmail.com
 * <br>
 * Date: 2/20/19
 */
@Path("/header")
@Produces(MediaType.APPLICATION_JSON)
public class HeaderConsumingResource {

    public static final String HEADER_NAME = "header-name";

    @POST
    public Map<String, String> postWithHeader(@HeaderParam(HEADER_NAME) String headerValue, String url) {
        Map<String, String> allHeaders = RestClientBuilder.newBuilder()
                .baseUri(URI.create(url))
                .build(AllHeadersReturningClient.class)
                .getAllHeaders();
        return allHeaders;
    }
}
