/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.log;

import com.mchange.v1.util.StringTokenizerUtils;
import com.mchange.v2.cfg.MultiPropertiesConfig;
import com.mchange.v2.log.FallbackMLog;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLogClasses;
import com.mchange.v2.log.MLogConfig;
import com.mchange.v2.log.MLogInitializationException;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.log.NameTransformer;
import java.util.ArrayList;

public abstract class MLog {
    private static NameTransformer _transformer;
    private static MLog _mlog;
    private static MLogger _logger;

    private static synchronized NameTransformer transformer() {
        return _transformer;
    }

    private static synchronized MLog mlog() {
        return _mlog;
    }

    private static synchronized MLogger logger() {
        return _logger;
    }

    public static synchronized void refreshConfig(MultiPropertiesConfig[] overrides, String overridesDescription) {
        MLogConfig.refresh(overrides, overridesDescription);
        String classnamesStr = MLogConfig.getProperty("com.mchange.v2.log.MLog");
        String[] classnames = null;
        if (classnamesStr == null) {
            classnamesStr = MLogConfig.getProperty("com.mchange.v2.log.mlog");
        }
        if (classnamesStr != null) {
            classnames = StringTokenizerUtils.tokenizeToArray(classnamesStr, ", \t\r\n");
        }
        boolean warn = false;
        MLog tmpml = null;
        if (classnames != null) {
            tmpml = MLog.findByClassnames(classnames, true);
        }
        if (tmpml == null) {
            tmpml = MLog.findByClassnames(MLogClasses.SEARCH_CLASSNAMES, false);
        }
        if (tmpml == null) {
            warn = true;
            tmpml = new FallbackMLog();
        }
        _mlog = tmpml;
        if (warn) {
            MLog.info("Using " + _mlog.getClass().getName() + " -- Named logger's not supported, everything goes to System.err.");
        }
        NameTransformer tmpt = null;
        String tClassName = MLogConfig.getProperty("com.mchange.v2.log.NameTransformer");
        if (tClassName == null) {
            tClassName = MLogConfig.getProperty("com.mchange.v2.log.nametransformer");
        }
        try {
            if (tClassName != null) {
                tmpt = (NameTransformer)Class.forName(tClassName).newInstance();
            }
        }
        catch (Exception e) {
            System.err.println("Failed to instantiate com.mchange.v2.log.NameTransformer '" + tClassName + "'!");
            e.printStackTrace();
        }
        _transformer = tmpt;
        _logger = MLog.getLogger(MLog.class);
        Thread bannerThread = new Thread("MLog-Init-Reporter"){
            final MLogger logo = MLog.access$000();
            String loggerDesc = MLog.access$100().getClass().getName();

            public void run() {
                if ("com.mchange.v2.log.jdk14logging.Jdk14MLog".equals(this.loggerDesc)) {
                    this.loggerDesc = "java 1.4+ standard";
                } else if ("com.mchange.v2.log.log4j.Log4jMLog".equals(this.loggerDesc)) {
                    this.loggerDesc = "log4j";
                } else if ("com.mchange.v2.log.slf4j.Slf4jMLog".equals(this.loggerDesc)) {
                    this.loggerDesc = "slf4j";
                }
                if (this.logo.isLoggable(MLevel.INFO)) {
                    this.logo.log(MLevel.INFO, "MLog clients using " + this.loggerDesc + " logging.");
                }
                MLogConfig.logDelayedItems(this.logo);
                if (this.logo.isLoggable(MLevel.FINEST)) {
                    this.logo.log(MLevel.FINEST, "Config available to MLog library: " + MLogConfig.dump());
                }
            }
        };
        bannerThread.start();
    }

    public static MLog findByClassnames(String[] classnames, boolean log_attempts_to_stderr) {
        int i;
        ArrayList<String> attempts = null;
        int len = classnames.length;
        for (i = 0; i < len; ++i) {
            try {
                return (MLog)Class.forName(MLogClasses.resolveIfAlias(classnames[i])).newInstance();
            }
            catch (Exception e) {
                if (e instanceof MLogInitializationException) {
                    System.err.println("MLog initialization issue: " + e.getMessage());
                }
                if (attempts == null) {
                    attempts = new ArrayList<String>();
                }
                attempts.add(classnames[i]);
                if (!log_attempts_to_stderr) continue;
                System.err.println("com.mchange.v2.log.MLog '" + classnames[i] + "' could not be loaded!");
                e.printStackTrace();
                continue;
            }
        }
        System.err.println("Tried without success to load the following MLog classes:");
        len = attempts.size();
        for (i = 0; i < len; ++i) {
            System.err.println("\t" + attempts.get(i));
        }
        return null;
    }

    public static MLog instance() {
        return MLog.mlog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MLogger getLogger(String name) {
        NameTransformer xformer = null;
        MLog insty = null;
        Class<MLog> clazz = MLog.class;
        synchronized (MLog.class) {
            String xname;
            xformer = MLog.transformer();
            insty = MLog.instance();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            MLogger out = xformer == null ? MLog.instance().getMLogger(name) : ((xname = xformer.transformName(name)) != null ? insty.getMLogger(xname) : insty.getMLogger(name));
            return out;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MLogger getLogger(Class cl) {
        NameTransformer xformer = null;
        MLog insty = null;
        Class<MLog> clazz = MLog.class;
        synchronized (MLog.class) {
            String xname;
            xformer = MLog.transformer();
            insty = MLog.instance();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            MLogger out = xformer == null ? insty.getMLogger(cl) : ((xname = xformer.transformName(cl)) != null ? insty.getMLogger(xname) : insty.getMLogger(cl));
            return out;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MLogger getLogger() {
        NameTransformer xformer = null;
        MLog insty = null;
        Class<MLog> clazz = MLog.class;
        synchronized (MLog.class) {
            String xname;
            xformer = MLog.transformer();
            insty = MLog.instance();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            MLogger out = xformer == null ? insty.getMLogger() : ((xname = xformer.transformName()) != null ? insty.getMLogger(xname) : insty.getMLogger());
            return out;
        }
    }

    public static void log(MLevel l, String msg) {
        MLog.instance();
        MLog.getLogger().log(l, msg);
    }

    public static void log(MLevel l, String msg, Object param) {
        MLog.instance();
        MLog.getLogger().log(l, msg, param);
    }

    public static void log(MLevel l, String msg, Object[] params) {
        MLog.instance();
        MLog.getLogger().log(l, msg, params);
    }

    public static void log(MLevel l, String msg, Throwable t) {
        MLog.instance();
        MLog.getLogger().log(l, msg, t);
    }

    public static void logp(MLevel l, String srcClass, String srcMeth, String msg) {
        MLog.instance();
        MLog.getLogger().logp(l, srcClass, srcMeth, msg);
    }

    public static void logp(MLevel l, String srcClass, String srcMeth, String msg, Object param) {
        MLog.instance();
        MLog.getLogger().logp(l, srcClass, srcMeth, msg, param);
    }

    public static void logp(MLevel l, String srcClass, String srcMeth, String msg, Object[] params) {
        MLog.instance();
        MLog.getLogger().logp(l, srcClass, srcMeth, msg, params);
    }

    public static void logp(MLevel l, String srcClass, String srcMeth, String msg, Throwable t) {
        MLog.instance();
        MLog.getLogger().logp(l, srcClass, srcMeth, msg, t);
    }

    public static void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg) {
        MLog.instance();
        MLog.getLogger().logp(l, srcClass, srcMeth, rb, msg);
    }

    public static void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg, Object param) {
        MLog.instance();
        MLog.getLogger().logrb(l, srcClass, srcMeth, rb, msg, param);
    }

    public static void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg, Object[] params) {
        MLog.instance();
        MLog.getLogger().logrb(l, srcClass, srcMeth, rb, msg, params);
    }

    public static void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg, Throwable t) {
        MLog.instance();
        MLog.getLogger().logrb(l, srcClass, srcMeth, rb, msg, t);
    }

    public static void entering(String srcClass, String srcMeth) {
        MLog.instance();
        MLog.getLogger().entering(srcClass, srcMeth);
    }

    public static void entering(String srcClass, String srcMeth, Object param) {
        MLog.instance();
        MLog.getLogger().entering(srcClass, srcMeth, param);
    }

    public static void entering(String srcClass, String srcMeth, Object[] params) {
        MLog.instance();
        MLog.getLogger().entering(srcClass, srcMeth, params);
    }

    public static void exiting(String srcClass, String srcMeth) {
        MLog.instance();
        MLog.getLogger().exiting(srcClass, srcMeth);
    }

    public static void exiting(String srcClass, String srcMeth, Object result) {
        MLog.instance();
        MLog.getLogger().exiting(srcClass, srcMeth, result);
    }

    public static void throwing(String srcClass, String srcMeth, Throwable t) {
        MLog.instance();
        MLog.getLogger().throwing(srcClass, srcMeth, t);
    }

    public static void severe(String msg) {
        MLog.instance();
        MLog.getLogger().severe(msg);
    }

    public static void warning(String msg) {
        MLog.instance();
        MLog.getLogger().warning(msg);
    }

    public static void info(String msg) {
        MLog.instance();
        MLog.getLogger().info(msg);
    }

    public static void config(String msg) {
        MLog.instance();
        MLog.getLogger().config(msg);
    }

    public static void fine(String msg) {
        MLog.instance();
        MLog.getLogger().fine(msg);
    }

    public static void finer(String msg) {
        MLog.instance();
        MLog.getLogger().finer(msg);
    }

    public static void finest(String msg) {
        MLog.instance();
        MLog.getLogger().finest(msg);
    }

    public MLogger getMLogger(Class cl) {
        return this.getMLogger(cl.getName());
    }

    public abstract MLogger getMLogger(String var1);

    public abstract MLogger getMLogger();

    static /* synthetic */ MLogger access$000() {
        return _logger;
    }

    static /* synthetic */ MLog access$100() {
        return _mlog;
    }

    static {
        MLog.refreshConfig(null, null);
    }
}

