/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.lock;

import com.mchange.v2.lock.SharedUseExclusiveUseLock;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ExactReentrantSharedUseExclusiveUseLock
implements SharedUseExclusiveUseLock {
    Set waitingShared = new HashSet();
    List activeShared = new LinkedList();
    Set waitingExclusive = new HashSet();
    Thread activeExclusive = null;
    int exclusive_shared_reentries = 0;
    int exclusive_exclusive_reentries = 0;
    String name;

    public ExactReentrantSharedUseExclusiveUseLock(String name) {
        this.name = name;
    }

    public ExactReentrantSharedUseExclusiveUseLock() {
        this(null);
    }

    void status(String afterMethod) {
        System.err.println(this + " -- after " + afterMethod);
        System.err.println("waitingShared: " + this.waitingShared);
        System.err.println("activeShared: " + this.activeShared);
        System.err.println("waitingExclusive: " + this.waitingExclusive);
        System.err.println("activeExclusive: " + this.activeExclusive);
        System.err.println("exclusive_shared_reentries: " + this.exclusive_shared_reentries);
        System.err.println("exclusive_exclusive_reentries: " + this.exclusive_exclusive_reentries);
        System.err.println(" ---- ");
        System.err.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void acquireShared() throws InterruptedException {
        Thread t = Thread.currentThread();
        if (t == this.activeExclusive) {
            ++this.exclusive_shared_reentries;
        } else {
            try {
                this.waitingShared.add(t);
                while (!this.okayForShared()) {
                    this.wait();
                }
                this.activeShared.add(t);
                Object var3_2 = null;
                this.waitingShared.remove(t);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.waitingShared.remove(t);
                throw throwable;
            }
            {
            }
        }
    }

    public synchronized void relinquishShared() {
        Thread t = Thread.currentThread();
        if (t == this.activeExclusive) {
            --this.exclusive_shared_reentries;
            if (this.exclusive_shared_reentries < 0) {
                throw new IllegalStateException(t + " relinquished a shared lock (reentrant on exclusive) it did not hold!");
            }
        } else {
            boolean check = this.activeShared.remove(t);
            if (!check) {
                throw new IllegalStateException(t + " relinquished a shared lock it did not hold!");
            }
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void acquireExclusive() throws InterruptedException {
        Thread t = Thread.currentThread();
        if (t == this.activeExclusive) {
            ++this.exclusive_exclusive_reentries;
        } else {
            try {
                this.waitingExclusive.add(t);
                while (!this.okayForExclusive(t)) {
                    this.wait();
                }
                this.activeExclusive = t;
                Object var3_2 = null;
                this.waitingExclusive.remove(t);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.waitingExclusive.remove(t);
                throw throwable;
            }
            {
            }
        }
    }

    public synchronized void relinquishExclusive() {
        Thread t = Thread.currentThread();
        if (t != this.activeExclusive) {
            throw new IllegalStateException(t + " relinquished an exclusive lock it did not hold!");
        }
        if (this.exclusive_exclusive_reentries > 0) {
            --this.exclusive_exclusive_reentries;
        } else {
            if (this.exclusive_shared_reentries != 0) {
                throw new IllegalStateException(t + " relinquished an exclusive lock while it had reentered but not yet relinquished shared lock acquisitions!");
            }
            this.activeExclusive = null;
            this.notifyAll();
        }
    }

    private boolean okayForShared() {
        return this.activeExclusive == null && this.waitingExclusive.size() == 0;
    }

    private boolean okayForExclusive(Thread t) {
        int active_shared_sz = this.activeShared.size();
        if (active_shared_sz == 0) {
            return this.activeExclusive == null;
        }
        if (active_shared_sz == 1) {
            return this.activeShared.get(0) == t;
        }
        HashSet activeSharedNoDups = new HashSet(this.activeShared);
        return activeSharedNoDups.size() == 1 && activeSharedNoDups.contains(t);
    }

    public String toString() {
        return super.toString() + " [name=" + this.name + ']';
    }
}

