/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.modeler.modules;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.modeler.Registry;
import org.apache.commons.modeler.modules.ModelerSource;

public class MbeansDescriptorsDigesterSource
extends ModelerSource {
    private static Log log = LogFactory.getLog(MbeansDescriptorsDigesterSource.class);
    Registry registry;
    String location;
    String type;
    Object source;
    List mbeans = new ArrayList();

    public void setRegistry(Registry reg) {
        this.registry = reg;
    }

    public void setLocation(String loc) {
        this.location = loc;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    @Override
    public List loadDescriptors(Registry registry, String location, String type, Object source) throws Exception {
        this.setRegistry(registry);
        this.setLocation(location);
        this.setType(type);
        this.setSource(source);
        this.execute();
        return this.mbeans;
    }

    public void execute() throws Exception {
        if (this.registry == null) {
            this.registry = Registry.getRegistry();
        }
        InputStream stream = (InputStream)this.source;
        long t1 = System.currentTimeMillis();
        Digester digester = new Digester();
        digester.setNamespaceAware(false);
        digester.setValidating(false);
        URL url = this.registry.getClass().getResource("/org/apache/commons/modeler/mbeans-descriptors.dtd");
        digester.register("-//Apache Software Foundation//DTD Model MBeans Configuration File", url.toString());
        digester.push((Object)this.mbeans);
        digester.addObjectCreate("mbeans-descriptors/mbean", "org.apache.commons.modeler.ManagedBean");
        digester.addSetProperties("mbeans-descriptors/mbean");
        digester.addSetNext("mbeans-descriptors/mbean", "add", "java.lang.Object");
        digester.addObjectCreate("mbeans-descriptors/mbean/attribute", "org.apache.commons.modeler.AttributeInfo");
        digester.addSetProperties("mbeans-descriptors/mbean/attribute");
        digester.addSetNext("mbeans-descriptors/mbean/attribute", "addAttribute", "org.apache.commons.modeler.AttributeInfo");
        digester.addObjectCreate("mbeans-descriptors/mbean/attribute/descriptor/field", "org.apache.commons.modeler.FieldInfo");
        digester.addSetProperties("mbeans-descriptors/mbean/attribute/descriptor/field");
        digester.addSetNext("mbeans-descriptors/mbean/attribute/descriptor/field", "addField", "org.apache.commons.modeler.FieldInfo");
        digester.addObjectCreate("mbeans-descriptors/mbean/constructor", "org.apache.commons.modeler.ConstructorInfo");
        digester.addSetProperties("mbeans-descriptors/mbean/constructor");
        digester.addSetNext("mbeans-descriptors/mbean/constructor", "addConstructor", "org.apache.commons.modeler.ConstructorInfo");
        digester.addObjectCreate("mbeans-descriptors/mbean/constructor/descriptor/field", "org.apache.commons.modeler.FieldInfo");
        digester.addSetProperties("mbeans-descriptors/mbean/constructor/descriptor/field");
        digester.addSetNext("mbeans-descriptors/mbean/constructor/descriptor/field", "addField", "org.apache.commons.modeler.FieldInfo");
        digester.addObjectCreate("mbeans-descriptors/mbean/constructor/parameter", "org.apache.commons.modeler.ParameterInfo");
        digester.addSetProperties("mbeans-descriptors/mbean/constructor/parameter");
        digester.addSetNext("mbeans-descriptors/mbean/constructor/parameter", "addParameter", "org.apache.commons.modeler.ParameterInfo");
        digester.addObjectCreate("mbeans-descriptors/mbean/descriptor/field", "org.apache.commons.modeler.FieldInfo");
        digester.addSetProperties("mbeans-descriptors/mbean/descriptor/field");
        digester.addSetNext("mbeans-descriptors/mbean/descriptor/field", "addField", "org.apache.commons.modeler.FieldInfo");
        digester.addObjectCreate("mbeans-descriptors/mbean/notification", "org.apache.commons.modeler.NotificationInfo");
        digester.addSetProperties("mbeans-descriptors/mbean/notification");
        digester.addSetNext("mbeans-descriptors/mbean/notification", "addNotification", "org.apache.commons.modeler.NotificationInfo");
        digester.addObjectCreate("mbeans-descriptors/mbean/notification/descriptor/field", "org.apache.commons.modeler.FieldInfo");
        digester.addSetProperties("mbeans-descriptors/mbean/notification/descriptor/field");
        digester.addSetNext("mbeans-descriptors/mbean/notification/descriptor/field", "addField", "org.apache.commons.modeler.FieldInfo");
        digester.addCallMethod("mbeans-descriptors/mbean/notification/notification-type", "addNotifType", 0);
        digester.addObjectCreate("mbeans-descriptors/mbean/operation", "org.apache.commons.modeler.OperationInfo");
        digester.addSetProperties("mbeans-descriptors/mbean/operation");
        digester.addSetNext("mbeans-descriptors/mbean/operation", "addOperation", "org.apache.commons.modeler.OperationInfo");
        digester.addObjectCreate("mbeans-descriptors/mbean/operation/descriptor/field", "org.apache.commons.modeler.FieldInfo");
        digester.addSetProperties("mbeans-descriptors/mbean/operation/descriptor/field");
        digester.addSetNext("mbeans-descriptors/mbean/operation/descriptor/field", "addField", "org.apache.commons.modeler.FieldInfo");
        digester.addObjectCreate("mbeans-descriptors/mbean/operation/parameter", "org.apache.commons.modeler.ParameterInfo");
        digester.addSetProperties("mbeans-descriptors/mbean/operation/parameter");
        digester.addSetNext("mbeans-descriptors/mbean/operation/parameter", "addParameter", "org.apache.commons.modeler.ParameterInfo");
        try {
            digester.parse(stream);
        }
        catch (Exception e) {
            log.error((Object)"Error digesting Registry data", (Throwable)e);
            throw e;
        }
        long t2 = System.currentTimeMillis();
        log.info((Object)("Loaded registry information (digester) " + (t2 - t1) + " ms"));
    }
}

