/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIServerImpl;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.remote.ConnectionResolver;
import mx4j.remote.MX4JRemoteUtils;

public class RMIConnectorServer
extends JMXConnectorServer {
    public static final String JNDI_REBIND_ATTRIBUTE = "jmx.remote.jndi.rebind";
    public static final String RMI_CLIENT_SOCKET_FACTORY_ATTRIBUTE = "jmx.remote.rmi.client.socket.factory";
    public static final String RMI_SERVER_SOCKET_FACTORY_ATTRIBUTE = "jmx.remote.rmi.server.socket.factory";
    private JMXServiceURL url;
    private final Map environment;
    private RMIServerImpl rmiServer;
    private final ClassLoader defaultClassLoader;
    private boolean active;
    private boolean stopped;

    public RMIConnectorServer(JMXServiceURL url, Map environment) throws IOException {
        this(url, environment, null, null);
    }

    public RMIConnectorServer(JMXServiceURL url, Map environment, MBeanServer server) throws IOException {
        this(url, environment, null, server);
    }

    public RMIConnectorServer(JMXServiceURL url, Map environment, RMIServerImpl rmiServer, MBeanServer server) throws IOException {
        super(server);
        if (url == null) {
            throw new IllegalArgumentException("JMXServiceURL cannot be null");
        }
        this.url = url;
        this.environment = environment == null ? new HashMap() : new HashMap(environment);
        this.rmiServer = rmiServer;
        this.defaultClassLoader = this.findDefaultClassLoader(this.environment, server);
    }

    private ClassLoader findDefaultClassLoader(Map environment, MBeanServer server) throws IllegalArgumentException {
        Object loader = environment.get("jmx.remote.default.class.loader");
        Object loaderName = environment.get("jmx.remote.default.class.loader.name");
        if (loader != null && loaderName != null) {
            throw new IllegalArgumentException("Environment properties jmx.remote.default.class.loader and jmx.remote.default.class.loader.name cannot be both defined");
        }
        if (loader != null) {
            if (!(loader instanceof ClassLoader)) {
                throw new IllegalArgumentException("Environment property jmx.remote.default.class.loader must be a ClassLoader");
            }
            return (ClassLoader)loader;
        }
        if (loaderName != null) {
            if (!(loaderName instanceof ObjectName)) {
                throw new IllegalArgumentException("Environment property jmx.remote.default.class.loader.name must be an ObjectName");
            }
            ObjectName name = (ObjectName)loaderName;
            try {
                if (!server.isInstanceOf(name, ClassLoader.class.getName())) {
                    throw new InstanceNotFoundException();
                }
                return server.getClassLoader((ObjectName)loader);
            }
            catch (InstanceNotFoundException x) {
                throw new IllegalArgumentException("ObjectName " + name + " defined by environment property " + "jmx.remote.default.class.loader.name" + " must name a ClassLoader");
            }
        }
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    public JMXServiceURL getAddress() {
        return this.url;
    }

    @Override
    public Map getAttributes() {
        Map env = MX4JRemoteUtils.removeNonSerializableEntries(this.environment);
        return Collections.unmodifiableMap(env);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    private boolean isStopped() {
        return this.stopped;
    }

    @Override
    public synchronized void start() throws IOException {
        Logger logger = this.getLogger();
        if (this.isActive()) {
            if (logger.isEnabledFor(0)) {
                logger.trace("This RMIConnectorServer has already been started");
            }
            return;
        }
        if (this.isStopped()) {
            if (logger.isEnabledFor(0)) {
                logger.trace("This RMIConnectorServer has already been stopped");
            }
            throw new IOException("This RMIConnectorServer has already been stopped");
        }
        MBeanServer server = this.getMBeanServer();
        if (server == null) {
            throw new IllegalStateException("This RMIConnectorServer is not attached to an MBeanServer");
        }
        JMXServiceURL address = this.getAddress();
        String protocol = address.getProtocol();
        ConnectionResolver resolver = ConnectionResolver.newConnectionResolver(protocol, this.environment);
        if (this.rmiServer == null) {
            if (resolver == null) {
                throw new MalformedURLException("Unsupported protocol: " + protocol);
            }
            this.rmiServer = (RMIServerImpl)resolver.createServer(address, this.environment);
        }
        this.rmiServer.setRMIConnectorServer(this);
        this.rmiServer.setMBeanServer(server);
        this.rmiServer.setDefaultClassLoader(this.defaultClassLoader);
        this.rmiServer.export();
        this.url = resolver.bindServer(this.rmiServer, address, this.environment);
        this.active = true;
        if (logger.isEnabledFor(20)) {
            logger.info("RMIConnectorServer started at: " + this.url);
        }
    }

    @Override
    public synchronized void stop() throws IOException {
        JMXServiceURL address;
        String protocol;
        ConnectionResolver resolver;
        if (this.isStopped()) {
            return;
        }
        this.stopped = true;
        this.active = false;
        if (this.rmiServer != null) {
            this.rmiServer.close();
        }
        if ((resolver = ConnectionResolver.newConnectionResolver(protocol = (address = this.getAddress()).getProtocol(), this.environment)) == null) {
            throw new MalformedURLException("Unsupported protocol: " + protocol);
        }
        resolver.unbindServer(this.rmiServer, address, this.environment);
        resolver.destroyServer(this.rmiServer, address, this.environment);
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info("RMIConnectorServer stopped at: " + address);
        }
    }

    @Override
    public JMXConnector toJMXConnector(Map env) throws IOException {
        if (!this.isActive()) {
            throw new IllegalStateException("This JMXConnectorServer has not been started");
        }
        return super.toJMXConnector(env);
    }

    @Override
    protected void connectionOpened(String connectionId, String message, Object userData) {
        super.connectionOpened(connectionId, message, userData);
    }

    @Override
    protected void connectionClosed(String connectionId, String message, Object userData) {
        super.connectionClosed(connectionId, message, userData);
    }

    @Override
    protected void connectionFailed(String connectionId, String message, Object userData) {
        super.connectionFailed(connectionId, message, userData);
    }

    private Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }
}

