/*
 * Decompiled with CFR 0.152.
 */
package mx4j.remote;

import java.io.IOException;
import javax.management.NotificationBroadcasterSupport;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;

public class ConnectionNotificationEmitter
extends NotificationBroadcasterSupport {
    private static long sequenceNumber;
    private JMXConnector connector;

    public ConnectionNotificationEmitter(JMXConnector connector) {
        this.connector = connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextNotificationNumber() {
        Class<ConnectionNotificationEmitter> clazz = ConnectionNotificationEmitter.class;
        synchronized (ConnectionNotificationEmitter.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sequenceNumber++;
        }
    }

    private String getConnectionId() {
        try {
            return this.connector.getConnectionId();
        }
        catch (IOException x) {
            return null;
        }
    }

    public void sendConnectionNotificationOpened() {
        JMXConnectionNotification notification = new JMXConnectionNotification("jmx.remote.connection.opened", this.connector, this.getConnectionId(), this.getNextNotificationNumber(), "Connection opened", null);
        this.sendNotification(notification);
    }

    public void sendConnectionNotificationClosed() {
        JMXConnectionNotification notification = new JMXConnectionNotification("jmx.remote.connection.closed", this.connector, this.getConnectionId(), this.getNextNotificationNumber(), "Connection closed", null);
        this.sendNotification(notification);
    }

    public void sendConnectionNotificationFailed() {
        JMXConnectionNotification notification = new JMXConnectionNotification("jmx.remote.connection.failed", this.connector, this.getConnectionId(), this.getNextNotificationNumber(), "Connection failed", null);
        this.sendNotification(notification);
    }

    public void sendConnectionNotificationLost(long howMany) {
        JMXConnectionNotification notification = new JMXConnectionNotification("jmx.remote.connection.notifs.lost", this.connector, this.getConnectionId(), this.getNextNotificationNumber(), "Some notification (" + howMany + ") was lost", null);
        this.sendNotification(notification);
    }
}

