/*
 * Decompiled with CFR 0.152.
 */
package mx4j.remote;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorProvider;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerProvider;
import javax.management.remote.JMXProviderException;
import javax.management.remote.JMXServiceURL;
import mx4j.log.Logger;
import mx4j.remote.ProviderHelper;

public class ProviderFactory
extends ProviderHelper {
    public static JMXConnector newJMXConnector(JMXServiceURL url, Map env) throws IOException {
        String protocol = ProviderFactory.normalizeProtocol(url.getProtocol());
        String providerPackages = ProviderFactory.findProviderPackageList(env, "jmx.remote.protocol.provider.pkgs");
        ClassLoader classLoader = ProviderFactory.findProviderClassLoader(env, "jmx.remote.protocol.provider.class.loader");
        List providers = ProviderFactory.loadProviders(JMXConnectorProvider.class, providerPackages, protocol, "ClientProvider", classLoader);
        for (int i = 0; i < providers.size(); ++i) {
            JMXConnectorProvider provider = (JMXConnectorProvider)providers.get(i);
            try {
                return provider.newJMXConnector(url, Collections.unmodifiableMap(env));
            }
            catch (JMXProviderException x) {
                throw x;
            }
            catch (IOException x) {
                continue;
            }
        }
        throw new MalformedURLException("Could not find provider for protocol " + protocol);
    }

    public static JMXConnectorServer newJMXConnectorServer(JMXServiceURL url, Map env, MBeanServer server) throws IOException {
        String protocol = ProviderFactory.normalizeProtocol(url.getProtocol());
        String providerPackages = ProviderFactory.findProviderPackageList(env, "jmx.remote.protocol.provider.pkgs");
        ClassLoader classLoader = ProviderFactory.findProviderClassLoader(env, "jmx.remote.protocol.provider.class.loader");
        List providers = ProviderFactory.loadProviders(JMXConnectorServerProvider.class, providerPackages, protocol, "ServerProvider", classLoader);
        for (int i = 0; i < providers.size(); ++i) {
            JMXConnectorServerProvider provider = (JMXConnectorServerProvider)providers.get(i);
            try {
                return provider.newJMXConnectorServer(url, Collections.unmodifiableMap(env), server);
            }
            catch (JMXProviderException x) {
                throw x;
            }
            catch (IOException x) {
                continue;
            }
        }
        throw new MalformedURLException("Could not find provider for protocol " + protocol);
    }

    private static String findEnvironmentProviderPackageList(Map environment, String key) throws JMXProviderException {
        String providerPackages = null;
        if (environment != null) {
            Logger logger = ProviderFactory.getLogger();
            Object pkgs = environment.get(key);
            if (logger.isEnabledFor(10)) {
                logger.debug("Provider packages in the environment: " + pkgs);
            }
            if (pkgs != null && !(pkgs instanceof String)) {
                throw new JMXProviderException("Provider package list must be a string");
            }
            providerPackages = (String)pkgs;
        }
        return providerPackages;
    }

    private static String findProviderPackageList(Map environment, String providerPkgsKey) throws JMXProviderException {
        String providerPackages = ProviderFactory.findEnvironmentProviderPackageList(environment, providerPkgsKey);
        if (providerPackages == null) {
            providerPackages = ProviderFactory.findSystemPackageList(providerPkgsKey);
        }
        if (providerPackages != null && providerPackages.trim().length() == 0) {
            throw new JMXProviderException("Provider package list cannot be an empty string");
        }
        providerPackages = providerPackages == null ? "mx4j.remote.provider|mx4j.tools.remote.provider" : providerPackages + "|mx4j.remote.provider|mx4j.tools.remote.provider";
        Logger logger = ProviderFactory.getLogger();
        if (logger.isEnabledFor(10)) {
            logger.debug("Provider packages list is: " + providerPackages);
        }
        return providerPackages;
    }

    private static ClassLoader findProviderClassLoader(Map environment, String providerLoaderKey) {
        Logger logger = ProviderFactory.getLogger();
        ClassLoader classLoader = null;
        if (environment != null) {
            Object loader = environment.get(providerLoaderKey);
            if (logger.isEnabledFor(10)) {
                logger.debug("Provider classloader in the environment: " + loader);
            }
            if (loader != null && !(loader instanceof ClassLoader)) {
                throw new IllegalArgumentException("Provider classloader is not a ClassLoader");
            }
            classLoader = (ClassLoader)loader;
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
            if (logger.isEnabledFor(10)) {
                logger.debug("Provider classloader in the environment: " + classLoader);
            }
        }
        environment.put("jmx.remote.protocol.provider.class.loader", classLoader);
        if (logger.isEnabledFor(0)) {
            logger.trace("Provider classloader added to the environment");
        }
        return classLoader;
    }

    private static List loadProviders(Class providerType, String packages, String protocol, String className, ClassLoader loader) throws JMXProviderException {
        ArrayList result;
        Logger logger;
        block13: {
            logger = ProviderFactory.getLogger();
            result = new ArrayList();
            StringTokenizer tokenizer = new StringTokenizer(packages, "|");
            while (tokenizer.hasMoreTokens()) {
                String pkg = tokenizer.nextToken().trim();
                if (logger.isEnabledFor(10)) {
                    logger.debug("Provider package: " + pkg);
                }
                if (pkg.length() == 0) {
                    throw new JMXProviderException("Empty package list not allowed: " + packages);
                }
                String providerClassName = ProviderFactory.constructClassName(pkg, protocol, className);
                Class providerClass = null;
                try {
                    providerClass = ProviderFactory.loadClass(providerClassName, loader);
                }
                catch (ClassNotFoundException x) {
                    if (!logger.isEnabledFor(10)) continue;
                    logger.debug("Provider class " + providerClassName + " not found, " + (tokenizer.hasMoreTokens() ? "continuing with next package" : "no more packages to try"));
                    continue;
                }
                catch (Exception x) {
                    if (logger.isEnabledFor(0)) {
                        logger.trace("Cannot load provider class " + providerClassName, x);
                    }
                    throw new JMXProviderException("Cannot load provider class " + providerClassName, x);
                }
                try {
                    Object provider = providerClass.newInstance();
                    result.add(provider);
                }
                catch (Exception x) {
                    if (logger.isEnabledFor(0)) {
                        logger.trace("Cannot instantiate provider class " + providerClassName, x);
                    }
                    throw new JMXProviderException("Cannot instantiate provider class " + providerClassName, x);
                }
            }
            try {
                List serviceProviders = ProviderFactory.fromServiceProviders(providerType, protocol, className, loader);
                result.addAll(serviceProviders);
            }
            catch (IOException x) {
                if (!logger.isEnabledFor(10)) break block13;
                logger.debug("Error retrieving service providers", x);
            }
        }
        if (logger.isEnabledFor(10)) {
            logger.debug("Providers found are: " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List fromServiceProviders(Class providerType, String protocol, String className, ClassLoader loader) throws IOException {
        String services = "META-INF/services/";
        Logger logger = ProviderFactory.getLogger();
        if (logger.isEnabledFor(10)) {
            logger.debug("Loading providers from " + services);
        }
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        Enumeration<URL> providerURLs = loader.getResources(services + providerType.getName());
        ArrayList providers = new ArrayList();
        while (providerURLs.hasMoreElements()) {
            final URL providerURL = providerURLs.nextElement();
            InputStream stream = null;
            try {
                stream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return providerURL.openStream();
                    }
                });
            }
            catch (PrivilegedActionException x) {
                Exception xx = x.getException();
                if (xx instanceof IOException) {
                    throw (IOException)xx;
                }
                throw new IOException(xx.toString());
            }
            BufferedReader reader = null;
            try {
                if (logger.isEnabledFor(10)) {
                    logger.debug("Reading provider from " + providerURL);
                }
                reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    int comment = line.indexOf(35);
                    if (comment >= 0) {
                        line = line.substring(0, comment);
                    }
                    if ((line = line.trim()).length() == 0) continue;
                    if (logger.isEnabledFor(10)) {
                        logger.debug("Found provider '" + line + "' in " + providerURL);
                    }
                    try {
                        Class<?> providerClass = loader.loadClass(line);
                        if (!providerType.isAssignableFrom(providerClass)) continue;
                        Object providerInstance = providerClass.newInstance();
                        providers.add(providerInstance);
                    }
                    catch (Exception ignored) {}
                }
            }
            finally {
                if (reader == null) continue;
                reader.close();
            }
        }
        return providers;
    }
}

