/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.Serializable;
import javax.management.RuntimeOperationsException;

public class Attribute
implements Serializable {
    private static final long serialVersionUID = 2484220110589082382L;
    private final String name;
    private final Object value;
    private transient int hash;

    public Attribute(String name, Object value) {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("The name of an attribute cannot be null"));
        }
        this.name = name;
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        try {
            Attribute other = (Attribute)obj;
            boolean namesEqual = this.name.equals(other.name);
            boolean valuesEqual = false;
            valuesEqual = this.value == null ? other.value == null : this.value.equals(other.value);
            return namesEqual && valuesEqual;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.computeHash();
        }
        return this.hash;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return new StringBuffer("Attribute's name: ").append(this.getName()).append(", value: ").append(this.getValue()).toString();
    }

    private int computeHash() {
        int hash = this.name.hashCode();
        if (this.value != null) {
            hash ^= this.value.hashCode();
        }
        return hash;
    }
}

