/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import javax.management.JMRuntimeException;
import javax.management.MBeanServer;
import javax.management.MBeanServerBuilder;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerPermission;
import javax.management.ObjectName;
import javax.management.loading.ClassLoaderRepository;
import mx4j.log.Log;
import mx4j.log.Logger;

public class MBeanServerFactory {
    private static ArrayList servers = new ArrayList();

    private MBeanServerFactory() {
    }

    private static Logger getLogger() {
        return Log.getLogger((String)MBeanServerFactory.class.getName());
    }

    public static MBeanServer createMBeanServer() {
        return MBeanServerFactory.createMBeanServer(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MBeanServer createMBeanServer(String defaultDomain) {
        MBeanServer server = MBeanServerFactory.createMBeanServerImpl(defaultDomain, "createMBeanServer");
        ArrayList arrayList = servers;
        synchronized (arrayList) {
            servers.add(server);
        }
        Logger logger = MBeanServerFactory.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.trace((Object)("MBeanServer " + server + " registered successfully"));
        }
        return server;
    }

    public static MBeanServer newMBeanServer() {
        return MBeanServerFactory.newMBeanServer(null);
    }

    public static MBeanServer newMBeanServer(String defaultDomain) {
        return MBeanServerFactory.createMBeanServerImpl(defaultDomain, "newMBeanServer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseMBeanServer(MBeanServer server) {
        block14: {
            Logger logger = MBeanServerFactory.getLogger();
            try {
                if (logger.isEnabledFor(0)) {
                    logger.trace((Object)("Releasing MBeanServer " + server));
                }
                if (server != null) {
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        sm.checkPermission(new MBeanServerPermission("releaseMBeanServer"));
                    }
                    boolean removed = false;
                    ArrayList arrayList = servers;
                    synchronized (arrayList) {
                        removed = servers.remove(server);
                    }
                    if (removed) {
                        if (logger.isEnabledFor(0)) {
                            logger.trace((Object)("MBeanServer " + server + " released successfully"));
                        }
                    } else if (logger.isEnabledFor(20)) {
                        logger.info((Object)("MBeanServer " + server + " not released, cannot find it"));
                    }
                    break block14;
                }
                if (logger.isEnabledFor(10)) {
                    logger.debug((Object)"Cannot release a null MBeanServer");
                }
            }
            catch (SecurityException x) {
                if (logger.isEnabledFor(0)) {
                    logger.trace((Object)("Security Exception caught while releasing MBeanServer " + server), (Throwable)x);
                }
                throw x;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList findMBeanServer(String id) {
        Logger logger = MBeanServerFactory.getLogger();
        ArrayList<MBeanServer> list = null;
        try {
            SecurityManager sm;
            if (logger.isEnabledFor(0)) {
                logger.trace((Object)("Finding MBeanServer with ID: " + id));
            }
            if ((sm = System.getSecurityManager()) != null) {
                sm.checkPermission(new MBeanServerPermission("findMBeanServer"));
            }
            if (id == null) {
                list = (ArrayList<MBeanServer>)servers.clone();
            } else {
                list = new ArrayList<MBeanServer>();
                ArrayList arrayList = servers;
                synchronized (arrayList) {
                    for (int i = 0; i < servers.size(); ++i) {
                        MBeanServer server = (MBeanServer)servers.get(i);
                        String serverId = MBeanServerFactory.getMBeanServerId(server);
                        if (!id.equals(serverId)) continue;
                        list.add(server);
                        if (!logger.isEnabledFor(0)) continue;
                        logger.trace((Object)("Found matching MBeanServer: " + server));
                    }
                }
            }
            if (logger.isEnabledFor(0)) {
                logger.trace((Object)("MBeanServer(s) found: " + list));
            }
            return list;
        }
        catch (SecurityException x) {
            if (logger.isEnabledFor(0)) {
                logger.trace((Object)("Security Exception caught while finding MBeanServer with ID: " + id), (Throwable)x);
            }
            throw x;
        }
    }

    private static String getMBeanServerId(final MBeanServer server) {
        block6: {
            try {
                return (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return server.getAttribute(ObjectName.getInstance("JMImplementation:type=MBeanServerDelegate"), "MBeanServerId");
                    }
                });
            }
            catch (SecurityException x) {
                Logger logger = MBeanServerFactory.getLogger();
                if (logger.isEnabledFor(0)) {
                    logger.trace((Object)"No permission to get MBeanServerID", (Throwable)x);
                }
            }
            catch (PrivilegedActionException x) {
                Logger logger = MBeanServerFactory.getLogger();
                if (logger.isEnabledFor(0)) {
                    logger.trace((Object)"Could not get MBeanServerID", (Throwable)x.getException());
                }
            }
            catch (Throwable x) {
                Logger logger = MBeanServerFactory.getLogger();
                if (!logger.isEnabledFor(0)) break block6;
                logger.trace((Object)"Could not get MBeanServerID", x);
            }
        }
        return null;
    }

    public static ClassLoaderRepository getClassLoaderRepository(MBeanServer server) {
        return server.getClassLoaderRepository();
    }

    private static MBeanServer createMBeanServerImpl(String domain, String permission) {
        Logger logger = MBeanServerFactory.getLogger();
        boolean trace = logger.isEnabledFor(0);
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(new MBeanServerPermission(permission));
            }
            if (trace) {
                logger.trace((Object)"Obtaining MBeanServerBuilder");
            }
            MBeanServerBuilder builder = MBeanServerFactory.createMBeanServerBuilder();
            if (trace) {
                logger.trace((Object)("Using MBeanServerBuilder " + builder.getClass()));
            }
            if (trace) {
                logger.trace((Object)"Creating MBeanServerDelegate...");
            }
            MBeanServerDelegate delegate = builder.newMBeanServerDelegate();
            if (trace) {
                logger.trace((Object)("MBeanServerDelegate " + delegate.getClass() + " created successfully"));
            }
            if (trace) {
                logger.trace((Object)"Creating MBeanServer...");
            }
            MBeanServer mbs = builder.newMBeanServer(domain, null, delegate);
            if (trace) {
                logger.trace((Object)("MBeanServer " + mbs + " created successfully"));
            }
            if (logger.isEnabledFor(20)) {
                String mbeanServerId = MBeanServerFactory.getMBeanServerId(mbs);
                if (mbeanServerId != null) {
                    logger.info((Object)("Created MBeanServer with ID: " + mbeanServerId));
                } else {
                    logger.info((Object)"Created MBeanServer");
                }
            }
            return mbs;
        }
        catch (SecurityException x) {
            if (trace) {
                logger.trace((Object)"Security Exception caught while creating an MBeanServer", (Throwable)x);
            }
            throw x;
        }
    }

    private static MBeanServerBuilder createMBeanServerBuilder() {
        Class builderClass = MBeanServerFactory.loadMBeanServerBuilderClass();
        try {
            return (MBeanServerBuilder)builderClass.newInstance();
        }
        catch (ClassCastException e) {
            throw new JMRuntimeException("Specified MBeanServerBuilder must be a subclass of MBeanServerBuilder: " + builderClass);
        }
        catch (IllegalAccessException e) {
            throw new JMRuntimeException("Can't instantiate MBeanServerBuilder " + builderClass + ": " + e);
        }
        catch (InstantiationException e) {
            throw new JMRuntimeException("Can't instantiate MBeanServerBuilder " + builderClass + ": " + e);
        }
    }

    private static Class loadMBeanServerBuilderClass() {
        String builderClassName = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("javax.management.builder.initial");
            }
        });
        if (builderClassName == null || builderClassName.length() == 0) {
            return MBeanServerBuilder.class;
        }
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(builderClassName);
        }
        catch (ClassNotFoundException e) {
            throw new JMRuntimeException("MBeanServerBuilder class not found: " + builderClassName);
        }
    }
}

