/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.AttributeValueExp;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.StringValueExp;
import javax.management.ValueExp;

class MatchQueryExp
extends QueryEval
implements QueryExp {
    private static final long serialVersionUID = -7156603696948215014L;
    private final AttributeValueExp exp;
    private final String pattern;

    MatchQueryExp(AttributeValueExp exp, StringValueExp pattern) {
        this.exp = exp;
        this.pattern = pattern == null ? null : pattern.getValue();
    }

    @Override
    public void setMBeanServer(MBeanServer server) {
        super.setMBeanServer(server);
        if (this.exp != null) {
            this.exp.setMBeanServer(server);
        }
    }

    @Override
    public boolean apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        ValueExp value = this.exp.apply(name);
        if (value instanceof StringValueExp) {
            return this.wildcardMatch(((StringValueExp)value).getValue(), this.pattern);
        }
        return false;
    }

    private boolean wildcardMatch(String s, String p) {
        if (s == null && p == null) {
            return true;
        }
        if (s == null) {
            return false;
        }
        if (p == null) {
            return true;
        }
        int si = 0;
        int pi = 0;
        int slen = s.length();
        int plen = p.length();
        while (pi < plen) {
            char c;
            if ((c = p.charAt(pi++)) == '?') {
                if (++si <= slen) continue;
                return false;
            }
            if (c == '[') {
                boolean wantit = true;
                boolean seenit = false;
                if (p.charAt(pi) == '!') {
                    wantit = false;
                    ++pi;
                }
                while (++pi < plen && (c = p.charAt(pi)) != ']') {
                    if (p.charAt(pi) == '-' && pi + 1 < plen) {
                        if (s.charAt(si) >= c && s.charAt(si) <= p.charAt(pi + 1)) {
                            seenit = true;
                        }
                        ++pi;
                        continue;
                    }
                    if (c != s.charAt(si)) continue;
                    seenit = true;
                }
                if (pi >= plen || wantit != seenit) {
                    return false;
                }
                ++pi;
                ++si;
                continue;
            }
            if (c == '*') {
                if (pi >= plen) {
                    return true;
                }
                do {
                    if (!this.wildcardMatch(s.substring(si), p.substring(pi))) continue;
                    return true;
                } while (++si < slen);
                return false;
            }
            if (!(c == '\\' ? pi >= plen || p.charAt(pi++) != s.charAt(si++) : si >= slen || c != s.charAt(si++))) continue;
            return false;
        }
        return si == slen;
    }
}

