/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.management.Notification;
import javax.management.NotificationFilter;

public class NotificationFilterSupport
implements NotificationFilter,
Serializable {
    private static final long serialVersionUID = 6579080007561786969L;
    private static final String serialName = "enabledTypes";
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("enabledTypes", List.class)};
    private HashSet types = new HashSet();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NotificationFilterSupport)) {
            return false;
        }
        NotificationFilterSupport support = (NotificationFilterSupport)o;
        return this.types.equals(support.types);
    }

    public int hashCode() {
        return this.types.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableType(String type) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException("Null notification type");
        }
        HashSet hashSet = this.types;
        synchronized (hashSet) {
            this.types.add(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableAllTypes() {
        HashSet hashSet = this.types;
        synchronized (hashSet) {
            this.types.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableType(String type) {
        HashSet hashSet = this.types;
        synchronized (hashSet) {
            this.types.remove(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getEnabledTypes() {
        Vector v = new Vector();
        HashSet hashSet = this.types;
        synchronized (hashSet) {
            v.addAll(this.types);
        }
        return v;
    }

    @Override
    public boolean isNotificationEnabled(Notification notification) {
        String type = notification.getType();
        if (type != null) {
            for (String t : this.getEnabledTypes()) {
                if (!type.startsWith(t)) continue;
                return true;
            }
        }
        return false;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        Vector vector = (Vector)fields.get(serialName, null);
        if (fields.defaulted(serialName)) {
            throw new IOException("Serialized stream corrupted: expecting a non-null Vector");
        }
        if (this.types == null) {
            this.types = new HashSet();
        }
        this.types.clear();
        this.types.addAll(vector);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ObjectOutputStream.PutField fields = out.putFields();
        Vector vector = this.getEnabledTypes();
        fields.put(serialName, vector);
        out.writeFields();
    }
}

