/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularType;

public class ArrayType
extends OpenType
implements Serializable {
    private static final long serialVersionUID = 720504429830309770L;
    private int dimension = 0;
    private OpenType elementType = null;
    private transient int hashCode = 0;

    public ArrayType(int dimension, OpenType elementType) throws OpenDataException {
        super(ArrayType.createArrayName(elementType, dimension), ArrayType.createArrayName(elementType, dimension), ArrayType.createDescription(elementType, dimension));
        if (elementType instanceof ArrayType) {
            throw new OpenDataException("elementType can't be instance of ArrayType");
        }
        if (dimension <= 0) {
            throw new IllegalArgumentException("int type dimension must be greater than or equal to 1");
        }
        this.dimension = dimension;
        this.elementType = elementType;
    }

    public int getDimension() {
        return this.dimension;
    }

    public OpenType getElementOpenType() {
        return this.elementType;
    }

    @Override
    public boolean isValue(Object object) {
        if (object == null || !object.getClass().isArray()) {
            return false;
        }
        if (this.elementType instanceof SimpleType) {
            return this.getClassName().equals(object.getClass().getName());
        }
        if (this.elementType instanceof TabularType || this.elementType instanceof CompositeType) {
            try {
                Class<?> elementClass = Thread.currentThread().getContextClassLoader().loadClass(this.getClassName());
                if (elementClass.isAssignableFrom(object.getClass())) {
                    return this.checkElements((Object[])object, this.dimension);
                }
            }
            catch (ClassNotFoundException x) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object != null && object instanceof ArrayType) {
            ArrayType checkedType = (ArrayType)object;
            if (checkedType.dimension != this.dimension) {
                return false;
            }
            if (this.getElementOpenType().equals(checkedType.getElementOpenType())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.computeHashCode();
        }
        return this.hashCode;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.elementType.getClassName());
        sb.append("(typename=");
        sb.append(this.getTypeName());
        sb.append(",dimension=");
        sb.append("" + this.dimension);
        sb.append(",elementType=");
        sb.append(this.elementType.toString());
        sb.append(")");
        return sb.toString();
    }

    private static String createDescription(OpenType type, int size) {
        StringBuffer sb = new StringBuffer("" + size);
        sb.append("-dimension array of ");
        sb.append(type.getClassName());
        return sb.toString();
    }

    private static String createArrayName(OpenType type, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("int type dimension must be greater than or equal to 1");
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            sb.append("[");
        }
        sb.append("L");
        sb.append(type.getClassName());
        sb.append(";");
        return sb.toString();
    }

    private void computeHashCode() {
        this.hashCode = this.dimension + this.elementType.hashCode();
    }

    private boolean checkElements(Object[] array, int dim) {
        if (dim == 1) {
            OpenType arrayType = this.getElementOpenType();
            for (int i = 0; i < array.length; ++i) {
                Object o = array[i];
                if (o == null || arrayType.isValue(o)) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < array.length; ++i) {
            Object o = array[i];
            if (o == null || this.checkElements((Object[])o, dim - 1)) continue;
            return false;
        }
        return true;
    }
}

