/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularData;

public class TabularType
extends OpenType
implements Serializable {
    private static final long serialVersionUID = 6554071860220659261L;
    private CompositeType rowType = null;
    private List indexNames = null;
    private transient int m_hashcode = 0;
    private transient String m_classDescription = null;

    public TabularType(String typeName, String description, CompositeType rowType, String[] indexNames) throws OpenDataException {
        super(TabularData.class.getName(), typeName, description);
        if (typeName.trim().length() == 0) {
            throw new IllegalArgumentException("TabularType name can't be empty");
        }
        if (description.trim().length() == 0) {
            throw new IllegalArgumentException("TabularType description can't be empty");
        }
        this.validate(rowType, indexNames);
        this.rowType = rowType;
        ArrayList<String> temp = new ArrayList<String>();
        for (int i = 0; i < indexNames.length; ++i) {
            temp.add(indexNames[i]);
        }
        this.indexNames = Collections.unmodifiableList(temp);
    }

    private void validate(CompositeType rowType, String[] indexNames) throws OpenDataException {
        if (rowType == null) {
            throw new IllegalArgumentException("The CompositeType passed in cannot be null");
        }
        if (indexNames == null || indexNames.length == 0) {
            throw new IllegalArgumentException("The String[] indexNames cannot be null or empty");
        }
        for (int i = 0; i < indexNames.length; ++i) {
            String item = indexNames[i];
            if (item == null || item.length() == 0) {
                throw new IllegalArgumentException("An Item in the indexNames[] cannot be null or of zero length");
            }
            if (rowType.containsKey(item)) continue;
            throw new OpenDataException("Element value: " + indexNames[i] + " at index: " + i + " is not a valid item name for RowType");
        }
    }

    public CompositeType getRowType() {
        return this.rowType;
    }

    public List getIndexNames() {
        return this.indexNames;
    }

    @Override
    public boolean isValue(Object object) {
        if (!(object instanceof TabularData)) {
            return false;
        }
        TabularData tabularData = (TabularData)object;
        return this.equals(tabularData.getTabularType());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TabularType)) {
            return false;
        }
        TabularType tabularType = (TabularType)object;
        return this.getRowType().equals(tabularType.getRowType()) && ((Object)this.getIndexNames()).equals(tabularType.getIndexNames()) && this.getTypeName().equals(tabularType.getTypeName());
    }

    @Override
    public int hashCode() {
        if (this.m_hashcode == 0) {
            int result = this.getTypeName().hashCode();
            result += this.getRowType().hashCode();
            List names = this.getIndexNames();
            for (int i = 0; i < names.size(); ++i) {
                Object name = names.get(i);
                result += name.hashCode();
            }
            this.m_hashcode = result;
        }
        return this.m_hashcode;
    }

    @Override
    public String toString() {
        if (this.m_classDescription == null) {
            StringBuffer classString = new StringBuffer("TabularType name: ").append(this.getTypeName());
            classString.append(" rowType: ").append(this.getRowType());
            classString.append("indexNames: ").append(this.getIndexNames());
            this.m_classDescription = classString.toString();
        }
        return this.m_classDescription;
    }
}

