/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.action;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.MissingResourceException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.apache.commons.beanutils.converters.BigIntegerConverter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.ByteConverter;
import org.apache.commons.beanutils.converters.CharacterConverter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.apache.commons.beanutils.converters.ShortConverter;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.PlugIn;
import org.apache.struts.action.RequestProcessor;
import org.apache.struts.config.ConfigRuleSet;
import org.apache.struts.config.DataSourceConfig;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.MessageResourcesConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.ModuleConfigFactory;
import org.apache.struts.config.PlugInConfig;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.MessageResourcesFactory;
import org.apache.struts.util.ModuleUtils;
import org.apache.struts.util.RequestUtils;
import org.apache.struts.util.ServletContextWriter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ActionServlet
extends HttpServlet {
    protected String config = "/WEB-INF/struts-config.xml";
    protected Digester configDigester = null;
    protected boolean convertNull = false;
    protected FastHashMap dataSources = new FastHashMap();
    protected MessageResources internal = null;
    protected String internalName = "org.apache.struts.action.ActionResources";
    protected static Log log = LogFactory.getLog(ActionServlet.class);
    protected RequestProcessor processor = null;
    protected String[] registrations = new String[]{"-//Apache Software Foundation//DTD Struts Configuration 1.0//EN", "/org/apache/struts/resources/struts-config_1_0.dtd", "-//Apache Software Foundation//DTD Struts Configuration 1.1//EN", "/org/apache/struts/resources/struts-config_1_1.dtd", "-//Apache Software Foundation//DTD Struts Configuration 1.2//EN", "/org/apache/struts/resources/struts-config_1_2.dtd", "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", "/org/apache/struts/resources/web-app_2_2.dtd", "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", "/org/apache/struts/resources/web-app_2_3.dtd"};
    protected String servletMapping = null;
    protected String servletName = null;

    public void destroy() {
        if (log.isDebugEnabled()) {
            log.debug((Object)this.internal.getMessage("finalizing"));
        }
        this.destroyModules();
        this.destroyInternal();
        this.getServletContext().removeAttribute("org.apache.struts.action.ACTION_SERVLET");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ActionServlet.class.getClassLoader();
        }
        try {
            LogFactory.release((ClassLoader)classLoader);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        PropertyUtils.clearDescriptors();
    }

    public void init() throws ServletException {
        try {
            this.initInternal();
            this.initOther();
            this.initServlet();
            this.getServletContext().setAttribute("org.apache.struts.action.ACTION_SERVLET", (Object)this);
            this.initModuleConfigFactory();
            ModuleConfig moduleConfig = this.initModuleConfig("", this.config);
            this.initModuleMessageResources(moduleConfig);
            this.initModuleDataSources(moduleConfig);
            this.initModulePlugIns(moduleConfig);
            moduleConfig.freeze();
            Enumeration names = this.getServletConfig().getInitParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!name.startsWith("config/")) continue;
                String prefix = name.substring(6);
                moduleConfig = this.initModuleConfig(prefix, this.getServletConfig().getInitParameter(name));
                this.initModuleMessageResources(moduleConfig);
                this.initModuleDataSources(moduleConfig);
                this.initModulePlugIns(moduleConfig);
                moduleConfig.freeze();
            }
            this.initModulePrefixes(this.getServletContext());
            this.destroyConfigDigester();
        }
        catch (UnavailableException ex) {
            throw ex;
        }
        catch (Throwable t) {
            log.error((Object)"Unable to initialize Struts ActionServlet due to an unexpected exception or error thrown, so marking the servlet as unavailable.  Most likely, this is due to an incorrect or missing library dependency.", t);
            throw new UnavailableException(t.getMessage());
        }
    }

    protected void initModulePrefixes(ServletContext context) {
        ArrayList<String> prefixList = new ArrayList<String>();
        Enumeration names = context.getAttributeNames();
        while (names.hasMoreElements()) {
            String prefix;
            String name = (String)names.nextElement();
            if (!name.startsWith("org.apache.struts.action.MODULE") || (prefix = name.substring("org.apache.struts.action.MODULE".length())).length() <= 0) continue;
            prefixList.add(prefix);
        }
        String[] prefixes = prefixList.toArray(new String[prefixList.size()]);
        context.setAttribute("org.apache.struts.globals.MODULE_PREFIXES", (Object)prefixes);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.process(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.process(request, response);
    }

    public void addServletMapping(String servletName, String urlPattern) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Process servletName=" + servletName + ", urlPattern=" + urlPattern));
        }
        if (servletName == null) {
            return;
        }
        if (servletName.equals(this.servletName)) {
            this.servletMapping = urlPattern;
        }
    }

    public MessageResources getInternal() {
        return this.internal;
    }

    protected void destroyModules() {
        ArrayList values = new ArrayList();
        Enumeration names = this.getServletContext().getAttributeNames();
        while (names.hasMoreElements()) {
            values.add(names.nextElement());
        }
        for (String name : values) {
            Object value = this.getServletContext().getAttribute(name);
            if (!(value instanceof ModuleConfig)) continue;
            ModuleConfig config = (ModuleConfig)value;
            if (this.getProcessorForModule(config) != null) {
                this.getProcessorForModule(config).destroy();
            }
            this.getServletContext().removeAttribute(name);
            PlugIn[] plugIns = (PlugIn[])this.getServletContext().getAttribute("org.apache.struts.action.PLUG_INS" + config.getPrefix());
            if (plugIns == null) continue;
            for (int i = 0; i < plugIns.length; ++i) {
                int j = plugIns.length - (i + 1);
                plugIns[j].destroy();
            }
            this.getServletContext().removeAttribute("org.apache.struts.action.PLUG_INS" + config.getPrefix());
        }
    }

    protected void destroyConfigDigester() {
        this.configDigester = null;
    }

    protected void destroyInternal() {
        this.internal = null;
    }

    protected ModuleConfig getModuleConfig(HttpServletRequest request) {
        ModuleConfig config = (ModuleConfig)request.getAttribute("org.apache.struts.action.MODULE");
        if (config == null) {
            config = (ModuleConfig)this.getServletContext().getAttribute("org.apache.struts.action.MODULE");
        }
        return config;
    }

    protected synchronized RequestProcessor getRequestProcessor(ModuleConfig config) throws ServletException {
        RequestProcessor processor = this.getProcessorForModule(config);
        if (processor == null) {
            try {
                processor = (RequestProcessor)RequestUtils.applicationInstance(config.getControllerConfig().getProcessorClass());
            }
            catch (Exception e) {
                throw new UnavailableException("Cannot initialize RequestProcessor of class " + config.getControllerConfig().getProcessorClass() + ": " + e);
            }
            processor.init(this, config);
            String key = "org.apache.struts.action.REQUEST_PROCESSOR" + config.getPrefix();
            this.getServletContext().setAttribute(key, (Object)processor);
        }
        return processor;
    }

    private RequestProcessor getProcessorForModule(ModuleConfig config) {
        String key = "org.apache.struts.action.REQUEST_PROCESSOR" + config.getPrefix();
        return (RequestProcessor)this.getServletContext().getAttribute(key);
    }

    protected void initModuleConfigFactory() {
        String configFactory = this.getServletConfig().getInitParameter("configFactory");
        if (configFactory != null) {
            ModuleConfigFactory.setFactoryClass(configFactory);
        }
    }

    protected ModuleConfig initModuleConfig(String prefix, String paths) throws ServletException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Initializing module path '" + prefix + "' configuration from '" + paths + "'"));
        }
        ModuleConfigFactory factoryObject = ModuleConfigFactory.createFactory();
        ModuleConfig config = factoryObject.createModuleConfig(prefix);
        Digester digester = this.initConfigDigester();
        while (paths.length() > 0) {
            digester.push(config);
            String path = null;
            int comma = paths.indexOf(44);
            if (comma >= 0) {
                path = paths.substring(0, comma).trim();
                paths = paths.substring(comma + 1);
            } else {
                path = paths.trim();
                paths = "";
            }
            if (path.length() < 1) break;
            this.parseModuleConfigFile(digester, path);
        }
        this.getServletContext().setAttribute("org.apache.struts.action.MODULE" + config.getPrefix(), (Object)config);
        FormBeanConfig[] fbs = config.findFormBeanConfigs();
        for (int i = 0; i < fbs.length; ++i) {
            if (!fbs[i].getDynamic()) continue;
            fbs[i].getDynaActionFormClass();
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseModuleConfigFile(Digester digester, String path) throws UnavailableException {
        InputStream input = null;
        try {
            URL url = this.getServletContext().getResource(path);
            if (url == null) {
                url = ((Object)((Object)this)).getClass().getResource(path);
            }
            if (url == null) {
                String msg = this.internal.getMessage("configMissing", (Object)path);
                log.error((Object)msg);
                throw new UnavailableException(msg);
            }
            InputSource is = new InputSource(url.toExternalForm());
            input = url.openStream();
            is.setByteStream(input);
            digester.parse(is);
        }
        catch (MalformedURLException e) {
            this.handleConfigException(path, e);
        }
        catch (IOException e) {
            this.handleConfigException(path, e);
        }
        catch (SAXException e) {
            this.handleConfigException(path, e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    throw new UnavailableException(e.getMessage());
                }
            }
        }
    }

    private void handleConfigException(String path, Exception e) throws UnavailableException {
        String msg = this.internal.getMessage("configParse", (Object)path);
        log.error((Object)msg, (Throwable)e);
        throw new UnavailableException(msg);
    }

    protected void initModuleDataSources(ModuleConfig config) throws ServletException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Initializing module path '" + config.getPrefix() + "' data sources"));
        }
        ServletContextWriter scw = new ServletContextWriter(this.getServletContext());
        DataSourceConfig[] dscs = config.findDataSourceConfigs();
        if (dscs == null) {
            dscs = new DataSourceConfig[]{};
        }
        this.dataSources.setFast(false);
        for (int i = 0; i < dscs.length; ++i) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Initializing module path '" + config.getPrefix() + "' data source '" + dscs[i].getKey() + "'"));
            }
            DataSource ds = null;
            try {
                ds = (DataSource)RequestUtils.applicationInstance(dscs[i].getType());
                BeanUtils.populate(ds, dscs[i].getProperties());
                ds.setLogWriter(scw);
            }
            catch (Exception e) {
                log.error((Object)this.internal.getMessage("dataSource.init", (Object)dscs[i].getKey()), (Throwable)e);
                throw new UnavailableException(this.internal.getMessage("dataSource.init", (Object)dscs[i].getKey()));
            }
            this.getServletContext().setAttribute(dscs[i].getKey() + config.getPrefix(), (Object)ds);
            this.dataSources.put((Object)dscs[i].getKey(), (Object)ds);
        }
        this.dataSources.setFast(true);
    }

    protected void initModulePlugIns(ModuleConfig config) throws ServletException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Initializing module path '" + config.getPrefix() + "' plug ins"));
        }
        PlugInConfig[] plugInConfigs = config.findPlugInConfigs();
        PlugIn[] plugIns = new PlugIn[plugInConfigs.length];
        this.getServletContext().setAttribute("org.apache.struts.action.PLUG_INS" + config.getPrefix(), (Object)plugIns);
        for (int i = 0; i < plugIns.length; ++i) {
            try {
                plugIns[i] = (PlugIn)RequestUtils.applicationInstance(plugInConfigs[i].getClassName());
                BeanUtils.populate(plugIns[i], plugInConfigs[i].getProperties());
                try {
                    PropertyUtils.setProperty(plugIns[i], "currentPlugInConfigObject", plugInConfigs[i]);
                }
                catch (Exception e) {
                    // empty catch block
                }
                plugIns[i].init(this, config);
                continue;
            }
            catch (ServletException e) {
                throw e;
            }
            catch (Exception e) {
                String errMsg = this.internal.getMessage("plugIn.init", (Object)plugInConfigs[i].getClassName());
                this.log(errMsg, e);
                throw new UnavailableException(errMsg);
            }
        }
    }

    protected void initModuleMessageResources(ModuleConfig config) throws ServletException {
        MessageResourcesConfig[] mrcs = config.findMessageResourcesConfigs();
        for (int i = 0; i < mrcs.length; ++i) {
            if (mrcs[i].getFactory() == null || mrcs[i].getParameter() == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Initializing module path '" + config.getPrefix() + "' message resources from '" + mrcs[i].getParameter() + "'"));
            }
            String factory = mrcs[i].getFactory();
            MessageResourcesFactory.setFactoryClass(factory);
            MessageResourcesFactory factoryObject = MessageResourcesFactory.createFactory();
            factoryObject.setConfig(mrcs[i]);
            MessageResources resources = factoryObject.createResources(mrcs[i].getParameter());
            resources.setReturnNull(mrcs[i].getNull());
            resources.setEscape(mrcs[i].isEscape());
            this.getServletContext().setAttribute(mrcs[i].getKey() + config.getPrefix(), (Object)resources);
        }
    }

    protected Digester initConfigDigester() throws ServletException {
        if (this.configDigester != null) {
            return this.configDigester;
        }
        this.configDigester = new Digester();
        this.configDigester.setNamespaceAware(true);
        this.configDigester.setValidating(this.isValidating());
        this.configDigester.setUseContextClassLoader(true);
        this.configDigester.addRuleSet(new ConfigRuleSet());
        for (int i = 0; i < this.registrations.length; i += 2) {
            URL url = ((Object)((Object)this)).getClass().getResource(this.registrations[i + 1]);
            if (url == null) continue;
            this.configDigester.register(this.registrations[i], url.toString());
        }
        this.addRuleSets();
        return this.configDigester;
    }

    private void addRuleSets() throws ServletException {
        String rulesets = this.getServletConfig().getInitParameter("rulesets");
        if (rulesets == null) {
            rulesets = "";
        }
        rulesets = rulesets.trim();
        String ruleset = null;
        while (rulesets.length() > 0) {
            int comma = rulesets.indexOf(",");
            if (comma < 0) {
                ruleset = rulesets.trim();
                rulesets = "";
            } else {
                ruleset = rulesets.substring(0, comma).trim();
                rulesets = rulesets.substring(comma + 1).trim();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Configuring custom Digester Ruleset of type " + ruleset));
            }
            try {
                RuleSet instance = (RuleSet)RequestUtils.applicationInstance(ruleset);
                this.configDigester.addRuleSet(instance);
            }
            catch (Exception e) {
                log.error((Object)"Exception configuring custom Digester RuleSet", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
        }
    }

    private boolean isValidating() {
        boolean validating = true;
        String value = this.getServletConfig().getInitParameter("validating");
        if ("false".equalsIgnoreCase(value) || "no".equalsIgnoreCase(value) || "n".equalsIgnoreCase(value) || "0".equalsIgnoreCase(value)) {
            validating = false;
        }
        return validating;
    }

    protected void initInternal() throws ServletException {
        try {
            this.internal = MessageResources.getMessageResources(this.internalName);
        }
        catch (MissingResourceException e) {
            log.error((Object)("Cannot load internal resources from '" + this.internalName + "'"), (Throwable)e);
            throw new UnavailableException("Cannot load internal resources from '" + this.internalName + "'");
        }
    }

    protected void initOther() throws ServletException {
        String value = null;
        value = this.getServletConfig().getInitParameter("config");
        if (value != null) {
            this.config = value;
        }
        if ("true".equalsIgnoreCase(value = this.getServletConfig().getInitParameter("convertNull")) || "yes".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value) || "y".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value)) {
            this.convertNull = true;
        }
        if (this.convertNull) {
            ConvertUtils.deregister();
            ConvertUtils.register(new BigDecimalConverter(null), BigDecimal.class);
            ConvertUtils.register(new BigIntegerConverter(null), BigInteger.class);
            ConvertUtils.register(new BooleanConverter(null), Boolean.class);
            ConvertUtils.register(new ByteConverter(null), Byte.class);
            ConvertUtils.register(new CharacterConverter(null), Character.class);
            ConvertUtils.register(new DoubleConverter(null), Double.class);
            ConvertUtils.register(new FloatConverter(null), Float.class);
            ConvertUtils.register(new IntegerConverter(null), Integer.class);
            ConvertUtils.register(new LongConverter(null), Long.class);
            ConvertUtils.register(new ShortConverter(null), Short.class);
        }
    }

    protected void initServlet() throws ServletException {
        InputStream input;
        this.servletName = this.getServletConfig().getServletName();
        Digester digester = new Digester();
        digester.push((Object)this);
        digester.setNamespaceAware(true);
        digester.setValidating(false);
        for (int i = 0; i < this.registrations.length; i += 2) {
            URL url = ((Object)((Object)this)).getClass().getResource(this.registrations[i + 1]);
            if (url == null) continue;
            digester.register(this.registrations[i], url.toString());
        }
        digester.addCallMethod("web-app/servlet-mapping", "addServletMapping", 2);
        digester.addCallParam("web-app/servlet-mapping/servlet-name", 0);
        digester.addCallParam("web-app/servlet-mapping/url-pattern", 1);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Scanning web.xml for controller servlet mapping");
        }
        if ((input = this.getServletContext().getResourceAsStream("/WEB-INF/web.xml")) == null) {
            log.error((Object)this.internal.getMessage("configWebXml"));
            throw new ServletException(this.internal.getMessage("configWebXml"));
        }
        try {
            digester.parse(input);
        }
        catch (IOException e) {
            log.error((Object)this.internal.getMessage("configWebXml"), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)this.internal.getMessage("configWebXml"), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                log.error((Object)this.internal.getMessage("configWebXml"), (Throwable)e);
                throw new ServletException((Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Mapping for servlet '" + this.servletName + "' = '" + this.servletMapping + "'"));
        }
        if (this.servletMapping != null) {
            this.getServletContext().setAttribute("org.apache.struts.action.SERVLET_MAPPING", (Object)this.servletMapping);
        }
    }

    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ModuleUtils.getInstance().selectModule(request, this.getServletContext());
        ModuleConfig config = this.getModuleConfig(request);
        RequestProcessor processor = this.getProcessorForModule(config);
        if (processor == null) {
            processor = this.getRequestProcessor(config);
        }
        processor.process(request, response);
    }
}

