/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.config;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.MutableDynaClass;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.action.DynaActionFormClass;
import org.apache.struts.config.FormPropertyConfig;
import org.apache.struts.validator.BeanValidatorForm;

public class FormBeanConfig
implements Serializable {
    protected boolean configured = false;
    protected HashMap formProperties = new HashMap();
    protected String lock = "";
    protected transient DynaActionFormClass dynaActionFormClass;
    protected boolean dynamic = false;
    protected String name = null;
    protected String type = null;
    protected boolean restricted = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynaActionFormClass getDynaActionFormClass() {
        if (!this.dynamic) {
            throw new IllegalArgumentException("ActionForm is not dynamic");
        }
        String string = this.lock;
        synchronized (string) {
            if (this.dynaActionFormClass == null) {
                this.dynaActionFormClass = new DynaActionFormClass(this);
            }
        }
        return this.dynaActionFormClass;
    }

    public boolean getDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.type = type;
        Class<DynaActionForm> dynaBeanClass = DynaActionForm.class;
        Class formBeanClass = this.formBeanClass();
        this.dynamic = formBeanClass != null ? dynaBeanClass.isAssignableFrom(formBeanClass) : false;
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    public void setRestricted(boolean restricted) {
        this.restricted = restricted;
    }

    public ActionForm createActionForm(ActionServlet servlet) throws IllegalAccessException, InstantiationException {
        DynaBean obj = null;
        obj = this.getDynamic() ? this.getDynaActionFormClass().newInstance() : this.formBeanClass().newInstance();
        ActionForm form = null;
        form = obj instanceof ActionForm ? (ActionForm)((Object)obj) : new BeanValidatorForm(obj);
        form.setServlet(servlet);
        if (form instanceof DynaBean && ((DynaBean)((Object)form)).getDynaClass() instanceof MutableDynaClass) {
            DynaBean dynaBean = (DynaBean)((Object)form);
            MutableDynaClass dynaClass = (MutableDynaClass)dynaBean.getDynaClass();
            dynaClass.setRestricted(false);
            FormPropertyConfig[] props = this.findFormPropertyConfigs();
            for (int i = 0; i < props.length; ++i) {
                dynaClass.add(props[i].getName(), props[i].getTypeClass());
                dynaBean.set(props[i].getName(), props[i].initial());
            }
            dynaClass.setRestricted(this.isRestricted());
        }
        return form;
    }

    public void addFormPropertyConfig(FormPropertyConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        if (this.formProperties.containsKey(config.getName())) {
            throw new IllegalArgumentException("Property " + config.getName() + " already defined");
        }
        this.formProperties.put(config.getName(), config);
    }

    public FormPropertyConfig findFormPropertyConfig(String name) {
        return (FormPropertyConfig)this.formProperties.get(name);
    }

    public FormPropertyConfig[] findFormPropertyConfigs() {
        FormPropertyConfig[] results = new FormPropertyConfig[this.formProperties.size()];
        return this.formProperties.values().toArray(results);
    }

    public void freeze() {
        this.configured = true;
        FormPropertyConfig[] fpconfigs = this.findFormPropertyConfigs();
        for (int i = 0; i < fpconfigs.length; ++i) {
            fpconfigs[i].freeze();
        }
    }

    public void removeFormPropertyConfig(FormPropertyConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.formProperties.remove(config.getName());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("FormBeanConfig[");
        sb.append("name=");
        sb.append(this.name);
        sb.append(",type=");
        sb.append(this.type);
        sb.append("]");
        return sb.toString();
    }

    protected Class formBeanClass() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        try {
            return classLoader.loadClass(this.getType());
        }
        catch (Exception e) {
            return null;
        }
    }
}

