/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.config.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ActionConfigMatcher;
import org.apache.struts.config.ControllerConfig;
import org.apache.struts.config.DataSourceConfig;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.MessageResourcesConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.PlugInConfig;

public class ModuleConfigImpl
implements Serializable,
ModuleConfig {
    protected HashMap actionConfigs = null;
    protected List actionConfigList = null;
    protected HashMap dataSources = null;
    protected HashMap exceptions = null;
    protected HashMap formBeans = null;
    protected HashMap forwards = null;
    protected HashMap messageResources = null;
    protected ArrayList plugIns = null;
    protected boolean configured = false;
    protected ControllerConfig controllerConfig = null;
    protected String prefix = null;
    protected String actionFormBeanClass = "org.apache.struts.action.ActionFormBean";
    protected String actionMappingClass = "org.apache.struts.action.ActionMapping";
    protected String actionForwardClass = "org.apache.struts.action.ActionForward";
    protected ActionConfigMatcher matcher = null;

    public ModuleConfigImpl() {
        this("/");
    }

    public ModuleConfigImpl(String prefix) {
        this.prefix = prefix;
        this.actionConfigs = new HashMap();
        this.actionConfigList = new ArrayList();
        this.actionFormBeanClass = "org.apache.struts.action.ActionFormBean";
        this.actionMappingClass = "org.apache.struts.action.ActionMapping";
        this.actionForwardClass = "org.apache.struts.action.ActionForward";
        this.configured = false;
        this.controllerConfig = null;
        this.dataSources = new HashMap();
        this.exceptions = new HashMap();
        this.formBeans = new HashMap();
        this.forwards = new HashMap();
        this.messageResources = new HashMap();
        this.plugIns = new ArrayList();
    }

    @Override
    public boolean getConfigured() {
        return this.configured;
    }

    @Override
    public ControllerConfig getControllerConfig() {
        if (this.controllerConfig == null) {
            this.controllerConfig = new ControllerConfig();
        }
        return this.controllerConfig;
    }

    @Override
    public void setControllerConfig(ControllerConfig cc) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.controllerConfig = cc;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.prefix = prefix;
    }

    @Override
    public String getActionFormBeanClass() {
        return this.actionFormBeanClass;
    }

    @Override
    public void setActionFormBeanClass(String actionFormBeanClass) {
        this.actionFormBeanClass = actionFormBeanClass;
    }

    @Override
    public String getActionMappingClass() {
        return this.actionMappingClass;
    }

    @Override
    public void setActionMappingClass(String actionMappingClass) {
        this.actionMappingClass = actionMappingClass;
    }

    @Override
    public void addActionConfig(ActionConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        config.setModuleConfig(this);
        this.actionConfigs.put(config.getPath(), config);
        this.actionConfigList.add(config);
    }

    @Override
    public void addDataSourceConfig(DataSourceConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.dataSources.put(config.getKey(), config);
    }

    @Override
    public void addExceptionConfig(ExceptionConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.exceptions.put(config.getType(), config);
    }

    @Override
    public void addFormBeanConfig(FormBeanConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.formBeans.put(config.getName(), config);
    }

    @Override
    public String getActionForwardClass() {
        return this.actionForwardClass;
    }

    @Override
    public void setActionForwardClass(String actionForwardClass) {
        this.actionForwardClass = actionForwardClass;
    }

    @Override
    public void addForwardConfig(ForwardConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.forwards.put(config.getName(), config);
    }

    @Override
    public void addMessageResourcesConfig(MessageResourcesConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.messageResources.put(config.getKey(), config);
    }

    @Override
    public void addPlugInConfig(PlugInConfig plugInConfig) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.plugIns.add(plugInConfig);
    }

    @Override
    public ActionConfig findActionConfig(String path) {
        ActionConfig config = (ActionConfig)this.actionConfigs.get(path);
        if (config == null) {
            config = this.matcher.match(path);
        }
        return config;
    }

    @Override
    public ActionConfig[] findActionConfigs() {
        ActionConfig[] results = new ActionConfig[this.actionConfigList.size()];
        return this.actionConfigList.toArray(results);
    }

    @Override
    public DataSourceConfig findDataSourceConfig(String key) {
        return (DataSourceConfig)this.dataSources.get(key);
    }

    @Override
    public DataSourceConfig[] findDataSourceConfigs() {
        DataSourceConfig[] results = new DataSourceConfig[this.dataSources.size()];
        return this.dataSources.values().toArray(results);
    }

    @Override
    public ExceptionConfig findExceptionConfig(String type) {
        return (ExceptionConfig)this.exceptions.get(type);
    }

    @Override
    public ExceptionConfig[] findExceptionConfigs() {
        ExceptionConfig[] results = new ExceptionConfig[this.exceptions.size()];
        return this.exceptions.values().toArray(results);
    }

    @Override
    public FormBeanConfig findFormBeanConfig(String name) {
        return (FormBeanConfig)this.formBeans.get(name);
    }

    @Override
    public FormBeanConfig[] findFormBeanConfigs() {
        FormBeanConfig[] results = new FormBeanConfig[this.formBeans.size()];
        return this.formBeans.values().toArray(results);
    }

    @Override
    public ForwardConfig findForwardConfig(String name) {
        return (ForwardConfig)this.forwards.get(name);
    }

    @Override
    public ForwardConfig[] findForwardConfigs() {
        ForwardConfig[] results = new ForwardConfig[this.forwards.size()];
        return this.forwards.values().toArray(results);
    }

    @Override
    public MessageResourcesConfig findMessageResourcesConfig(String key) {
        return (MessageResourcesConfig)this.messageResources.get(key);
    }

    @Override
    public MessageResourcesConfig[] findMessageResourcesConfigs() {
        MessageResourcesConfig[] results = new MessageResourcesConfig[this.messageResources.size()];
        return this.messageResources.values().toArray(results);
    }

    @Override
    public PlugInConfig[] findPlugInConfigs() {
        PlugInConfig[] results = new PlugInConfig[this.plugIns.size()];
        return this.plugIns.toArray(results);
    }

    @Override
    public void freeze() {
        this.configured = true;
        ActionConfig[] aconfigs = this.findActionConfigs();
        for (int i = 0; i < aconfigs.length; ++i) {
            aconfigs[i].freeze();
        }
        this.matcher = new ActionConfigMatcher(aconfigs);
        this.getControllerConfig().freeze();
        DataSourceConfig[] dsconfigs = this.findDataSourceConfigs();
        for (int i = 0; i < dsconfigs.length; ++i) {
            dsconfigs[i].freeze();
        }
        ExceptionConfig[] econfigs = this.findExceptionConfigs();
        for (int i = 0; i < econfigs.length; ++i) {
            econfigs[i].freeze();
        }
        FormBeanConfig[] fbconfigs = this.findFormBeanConfigs();
        for (int i = 0; i < fbconfigs.length; ++i) {
            fbconfigs[i].freeze();
        }
        ForwardConfig[] fconfigs = this.findForwardConfigs();
        for (int i = 0; i < fconfigs.length; ++i) {
            fconfigs[i].freeze();
        }
        MessageResourcesConfig[] mrconfigs = this.findMessageResourcesConfigs();
        for (int i = 0; i < mrconfigs.length; ++i) {
            mrconfigs[i].freeze();
        }
        PlugInConfig[] piconfigs = this.findPlugInConfigs();
        for (int i = 0; i < piconfigs.length; ++i) {
            piconfigs[i].freeze();
        }
    }

    @Override
    public void removeActionConfig(ActionConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        config.setModuleConfig(null);
        this.actionConfigs.remove(config.getPath());
        this.actionConfigList.remove(config);
    }

    @Override
    public void removeExceptionConfig(ExceptionConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.exceptions.remove(config.getType());
    }

    @Override
    public void removeDataSourceConfig(DataSourceConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.dataSources.remove(config.getKey());
    }

    @Override
    public void removeFormBeanConfig(FormBeanConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.formBeans.remove(config.getName());
    }

    @Override
    public void removeForwardConfig(ForwardConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.forwards.remove(config.getName());
    }

    @Override
    public void removeMessageResourcesConfig(MessageResourcesConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.messageResources.remove(config.getKey());
    }
}

