/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.upload;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.upload.DiskFile;
import org.apache.struts.upload.MultipartElement;
import org.apache.struts.upload.MultipartIterator;
import org.apache.struts.upload.MultipartRequestHandler;
import org.apache.struts.upload.MultipartRequestWrapper;
import org.apache.struts.util.ModuleUtils;

public class DiskMultipartRequestHandler
implements MultipartRequestHandler {
    protected static Log log = LogFactory.getLog(DiskMultipartRequestHandler.class);
    protected ActionServlet servlet;
    protected ActionMapping mapping;
    protected Hashtable fileElements;
    protected Hashtable textElements;
    protected Hashtable allElements;
    protected String tempDir;

    @Override
    public void handleRequest(HttpServletRequest request) throws ServletException {
        ModuleConfig moduleConfig = ModuleUtils.getInstance().getModuleConfig(request);
        this.retrieveTempDir(moduleConfig);
        try {
            MultipartElement element;
            MultipartIterator iterator = new MultipartIterator(request, moduleConfig.getControllerConfig().getBufferSize(), this.getMaxSize(moduleConfig.getControllerConfig().getMaxFileSize()), this.tempDir);
            this.textElements = new Hashtable();
            this.fileElements = new Hashtable();
            this.allElements = new Hashtable();
            while ((element = iterator.getNextElement()) != null) {
                if (!element.isFile()) {
                    this.createTextElement(request, element);
                    continue;
                }
                this.createDiskFile(element);
            }
            if (iterator.isMaxLengthExceeded()) {
                request.setAttribute("org.apache.struts.upload.MaxLengthExceeded", (Object)Boolean.TRUE);
            }
        }
        catch (IOException ioe) {
            throw new ServletException((Throwable)ioe);
        }
    }

    protected void createTextElement(HttpServletRequest request, MultipartElement element) {
        String[] textValues;
        if (request instanceof MultipartRequestWrapper) {
            ((MultipartRequestWrapper)request).setParameter(element.getName(), element.getValue());
        }
        if ((textValues = (String[])this.textElements.get(element.getName())) != null) {
            String[] textValues2 = new String[textValues.length + 1];
            System.arraycopy(textValues, 0, textValues2, 0, textValues.length);
            textValues2[textValues.length] = element.getValue();
            textValues = textValues2;
        } else {
            textValues = new String[]{element.getValue()};
        }
        this.textElements.put(element.getName(), textValues);
        this.allElements.put(element.getName(), textValues);
    }

    protected void createDiskFile(MultipartElement element) {
        File tempFile = element.getFile();
        if (tempFile.exists()) {
            DiskFile theFile = new DiskFile(tempFile.getAbsolutePath());
            theFile.setContentType(element.getContentType());
            theFile.setFileName(element.getFileName());
            theFile.setFileSize((int)tempFile.length());
            this.fileElements.put(element.getName(), theFile);
            this.allElements.put(element.getName(), theFile);
        }
    }

    @Override
    public Hashtable getAllElements() {
        return this.allElements;
    }

    @Override
    public Hashtable getTextElements() {
        return this.textElements;
    }

    @Override
    public Hashtable getFileElements() {
        return this.fileElements;
    }

    @Override
    public void rollback() {
        Enumeration names = this.fileElements.keys();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            DiskFile theFile = (DiskFile)this.fileElements.get(name);
            theFile.destroy();
        }
    }

    @Override
    public void finish() {
        this.rollback();
    }

    @Override
    public void setServlet(ActionServlet servlet) {
        this.servlet = servlet;
    }

    @Override
    public void setMapping(ActionMapping mapping) {
        this.mapping = mapping;
    }

    @Override
    public ActionServlet getServlet() {
        return this.servlet;
    }

    @Override
    public ActionMapping getMapping() {
        return this.mapping;
    }

    protected long getMaxSize(String stringSize) throws ServletException {
        long size = -1L;
        int multiplier = 1;
        if (stringSize.endsWith("K")) {
            multiplier = 1024;
            stringSize = stringSize.substring(0, stringSize.length() - 1);
        }
        if (stringSize.endsWith("M")) {
            multiplier = 0x100000;
            stringSize = stringSize.substring(0, stringSize.length() - 1);
        } else if (stringSize.endsWith("G")) {
            multiplier = 0x40000000;
            stringSize = stringSize.substring(0, stringSize.length() - 1);
        }
        try {
            size = Long.parseLong(stringSize);
        }
        catch (NumberFormatException nfe) {
            throw new ServletException("Invalid format for maximum file size");
        }
        return size * (long)multiplier;
    }

    protected void retrieveTempDir(ModuleConfig moduleConfig) {
        ActionServlet servlet = this.getServlet();
        if (servlet != null) {
            ServletContext context = servlet.getServletContext();
            try {
                this.tempDir = (String)context.getAttribute("javax.servlet.context.tempdir");
            }
            catch (ClassCastException cce) {
                this.tempDir = ((File)context.getAttribute("javax.servlet.context.tempdir")).getAbsolutePath();
            }
        }
        if (this.tempDir == null) {
            this.tempDir = moduleConfig.getControllerConfig().getTempDir();
            if (this.tempDir == null) {
                this.tempDir = System.getProperty("java.io.tmpdir");
                log.debug((Object)("DiskMultipartRequestHandler.handleRequest(): defaulting to java.io.tmpdir directory \"" + this.tempDir));
            }
        }
    }
}

