/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.MBeanServer;
import javax.management.NumericValueExp;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryEval;
import javax.management.StringValueExp;
import javax.management.ValueExp;

class BinaryOpValueExp
extends QueryEval
implements ValueExp {
    private static final long serialVersionUID = 1216286847881456786L;
    private final int op;
    private final ValueExp exp1;
    private final ValueExp exp2;

    BinaryOpValueExp(int op, ValueExp exp1, ValueExp exp2) {
        this.op = op;
        this.exp1 = exp1;
        this.exp2 = exp2;
    }

    @Override
    public void setMBeanServer(MBeanServer server) {
        super.setMBeanServer(server);
        if (this.exp1 != null) {
            this.exp1.setMBeanServer(server);
        }
        if (this.exp2 != null) {
            this.exp2.setMBeanServer(server);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ValueExp apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        if (this.exp1 == null || this.exp2 == null) throw new BadBinaryOpValueExpException(null);
        ValueExp val1 = this.exp1.apply(name);
        ValueExp val2 = this.exp2.apply(name);
        if (val1 instanceof NumericValueExp) {
            if (!(val2 instanceof NumericValueExp)) throw new BadBinaryOpValueExpException(val2);
            NumericValueExp num1 = (NumericValueExp)val1;
            NumericValueExp num2 = (NumericValueExp)val2;
            if (num1.isDouble() || num2.isDouble()) {
                double d1 = num1.doubleValue();
                double d2 = num2.doubleValue();
                switch (this.op) {
                    case 0: {
                        return Query.value(d1 + d2);
                    }
                    case 1: {
                        return Query.value(d1 - d2);
                    }
                    case 2: {
                        return Query.value(d1 * d2);
                    }
                    case 3: {
                        return Query.value(d1 / d2);
                    }
                }
                throw new BadBinaryOpValueExpException(null);
            } else {
                long l1 = num1.longValue();
                long l2 = num2.longValue();
                switch (this.op) {
                    case 0: {
                        return Query.value(l1 + l2);
                    }
                    case 1: {
                        return Query.value(l1 - l2);
                    }
                    case 2: {
                        return Query.value(l1 * l2);
                    }
                    case 3: {
                        return Query.value(l1 / l2);
                    }
                }
            }
            throw new BadBinaryOpValueExpException(null);
        } else {
            if (!(val1 instanceof StringValueExp)) throw new BadBinaryOpValueExpException(val1);
            if (!(val2 instanceof StringValueExp)) throw new BadBinaryOpValueExpException(val2);
            String s1 = ((StringValueExp)val1).getValue();
            String s2 = ((StringValueExp)val2).getValue();
            switch (this.op) {
                case 0: {
                    return Query.value(String.valueOf(s1) + String.valueOf(s2));
                }
            }
            throw new BadStringOperationException("Trying to perform an operation on Strings that is not concatenation");
        }
    }
}

