/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import java.lang.reflect.Method;
import javax.management.Descriptor;
import javax.management.DescriptorAccess;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanInfoSupport;

public class ModelMBeanAttributeInfo
extends MBeanAttributeInfo
implements DescriptorAccess,
Cloneable {
    private static final long serialVersionUID = 6181543027787327345L;
    private Descriptor attrDescriptor;

    public ModelMBeanAttributeInfo(String name, String description, Method getter, Method setter) throws IntrospectionException {
        this(name, description, getter, setter, null);
    }

    public ModelMBeanAttributeInfo(String name, String description, Method getter, Method setter, Descriptor descriptor) throws IntrospectionException {
        super(name, description, getter, setter);
        this.checkAndSetDescriptor(descriptor);
    }

    public ModelMBeanAttributeInfo(String name, String type, String description, boolean isReadable, boolean isWritable, boolean isIs) {
        this(name, type, description, isReadable, isWritable, isIs, null);
    }

    public ModelMBeanAttributeInfo(String name, String type, String description, boolean isReadable, boolean isWritable, boolean isIs, Descriptor descriptor) {
        super(name, type, description, isReadable, isWritable, isIs);
        this.checkAndSetDescriptor(descriptor);
    }

    public ModelMBeanAttributeInfo(ModelMBeanAttributeInfo copy) {
        super(copy.getName(), copy.getType(), copy.getDescription(), copy.isReadable(), copy.isWritable(), copy.isIs());
        this.checkAndSetDescriptor(copy.getDescriptor());
    }

    @Override
    public Object clone() {
        return new ModelMBeanAttributeInfo(this);
    }

    @Override
    public Descriptor getDescriptor() {
        return (Descriptor)this.attrDescriptor.clone();
    }

    @Override
    public void setDescriptor(Descriptor descriptor) {
        if (descriptor == null) {
            this.attrDescriptor = this.createDefaultDescriptor();
        } else if (this.isDescriptorValid(descriptor)) {
            this.attrDescriptor = (Descriptor)descriptor.clone();
        } else {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid descriptor"));
        }
    }

    private void checkAndSetDescriptor(Descriptor descriptor) {
        if (descriptor == null) {
            this.attrDescriptor = this.createDefaultDescriptor();
        } else if (this.isDescriptorValid(descriptor)) {
            this.attrDescriptor = (Descriptor)descriptor.clone();
            if (this.attrDescriptor.getFieldValue("displayname") == null) {
                this.attrDescriptor.setField("displayname", this.getName());
            }
        } else {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid Descriptor"));
        }
    }

    private boolean isDescriptorValid(Descriptor descriptor) {
        if (!descriptor.isValid()) {
            return false;
        }
        String[] names = descriptor.getFieldNames();
        if (!ModelMBeanInfoSupport.containsIgnoreCase(names, "name") || !ModelMBeanInfoSupport.containsIgnoreCase(names, "descriptortype")) {
            return false;
        }
        String name = this.getName();
        if (name == null) {
            return false;
        }
        if (!name.equals(descriptor.getFieldValue("name"))) {
            return false;
        }
        String desctype = (String)descriptor.getFieldValue("descriptortype");
        return desctype.compareToIgnoreCase("attribute") == 0;
    }

    private Descriptor createDefaultDescriptor() {
        String[] names = new String[]{"name", "descriptorType", "displayName"};
        Object[] values = new Object[]{this.getName(), "attribute", this.getName()};
        return new DescriptorSupport(names, values);
    }
}

