/*
 * Decompiled with CFR 0.152.
 */
package mx4j.server;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.server.CachingReflectionMBeanInvoker;
import mx4j.server.MBeanInvoker;
import mx4j.server.MBeanMetaData;
import org.apache.bcel.generic.ARRAYLENGTH;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class BCELMBeanInvoker
extends CachingReflectionMBeanInvoker {
    private static final String LOGGER_CATEGORY = BCELMBeanInvoker.class.getName();

    protected BCELMBeanInvoker() {
    }

    public static synchronized MBeanInvoker create(final MBeanMetaData metadata) {
        String parentName = BCELMBeanInvoker.class.getName();
        final String name = parentName + "Generated";
        ClassGen classGen = new ClassGen(name, parentName, "<generated-on-the-fly>", 49, null);
        classGen.addEmptyConstructor(1);
        classGen.addMethod(BCELMBeanInvoker.createInvokeImpl(metadata, classGen, name));
        final byte[] bytes = classGen.getJavaClass().getBytes();
        try {
            return (BCELMBeanInvoker)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Class<?> cls = new BCELClassLoader(metadata.getClassLoader(), bytes).loadClass(name);
                    return cls.newInstance();
                }
            });
        }
        catch (Throwable x) {
            Logger logger = Log.getLogger(LOGGER_CATEGORY);
            if (logger.isEnabledFor(20)) {
                logger.info("Cannot create on-the-fly MBeanInvoker class, going with reflection MBeanInvoker", x);
            }
            return new CachingReflectionMBeanInvoker();
        }
    }

    private static org.apache.bcel.classfile.Method createInvokeImpl(MBeanMetaData metadata, ClassGen classGen, String clsName) {
        BranchInstruction branch;
        int i;
        InstructionList implementation = new InstructionList();
        ObjectType metadataType = new ObjectType(MBeanMetaData.class.getName());
        Type[] signature = new Type[]{metadataType, Type.STRING, new ArrayType((Type)Type.STRING, 1), new ArrayType((Type)Type.OBJECT, 1)};
        MethodGen mthd = new MethodGen(4, (Type)Type.OBJECT, signature, new String[]{"metadata", "method", "params", "args"}, "invokeImpl", clsName, implementation, classGen.getConstantPool());
        mthd.addException("java.lang.Throwable");
        InstructionFactory factory = new InstructionFactory(classGen);
        Method[] methods = metadata.getMBeanInterface().getMethods();
        ArrayList tests = new ArrayList();
        ArrayList catches = new ArrayList();
        for (int i2 = 0; i2 < methods.length; ++i2) {
            Method method = methods[i2];
            catches.addAll(BCELMBeanInvoker.generateDirectInvokeBranch(classGen, mthd, implementation, factory, metadata.getMBeanInterface().getName(), method, tests));
        }
        InstructionHandle invokeSuper = implementation.append(factory.createThis());
        for (i = 0; i < tests.size(); ++i) {
            branch = (BranchInstruction)tests.get(i);
            branch.setTarget(invokeSuper);
        }
        tests.clear();
        for (i = 0; i < catches.size(); ++i) {
            branch = (BranchInstruction)catches.get(i);
            branch.setTarget(invokeSuper);
        }
        catches.clear();
        implementation.append((Instruction)InstructionFactory.createLoad((Type)metadataType, (int)1));
        implementation.append((Instruction)InstructionFactory.createLoad((Type)Type.STRING, (int)2));
        implementation.append((Instruction)InstructionFactory.createLoad((Type)new ArrayType((Type)Type.STRING, 1), (int)3));
        implementation.append((Instruction)InstructionFactory.createLoad((Type)new ArrayType((Type)Type.OBJECT, 1), (int)4));
        implementation.append((Instruction)factory.createInvoke(BCELMBeanInvoker.class.getName(), "invokeImpl", (Type)Type.OBJECT, signature, (short)183));
        implementation.append((Instruction)InstructionFactory.createReturn((Type)Type.OBJECT));
        mthd.setMaxStack();
        org.apache.bcel.classfile.Method method = mthd.getMethod();
        implementation.dispose();
        return method;
    }

    private static List generateDirectInvokeBranch(ClassGen classGen, MethodGen methodGen, InstructionList implementation, InstructionFactory factory, String management, Method method, List tests) {
        ArrayList<BranchInstruction> catches = new ArrayList<BranchInstruction>();
        InstructionHandle startTest = implementation.append((Instruction)InstructionFactory.createLoad((Type)Type.STRING, (int)2));
        for (int i = 0; i < tests.size(); ++i) {
            BranchInstruction branch = (BranchInstruction)tests.get(i);
            branch.setTarget(startTest);
        }
        tests.clear();
        implementation.append((CompoundInstruction)new PUSH(classGen.getConstantPool(), method.getName()));
        implementation.append((Instruction)factory.createInvoke(String.class.getName(), "equals", (Type)Type.BOOLEAN, new Type[]{Type.OBJECT}, (short)182));
        BranchInstruction test1 = InstructionFactory.createBranchInstruction((short)153, null);
        tests.add(test1);
        implementation.append(test1);
        implementation.append((Instruction)InstructionFactory.createLoad((Type)new ArrayType((Type)Type.OBJECT, 1), (int)4));
        implementation.append((Instruction)new ARRAYLENGTH());
        implementation.append((CompoundInstruction)new PUSH(classGen.getConstantPool(), method.getParameterTypes().length));
        BranchInstruction test2 = InstructionFactory.createBranchInstruction((short)160, null);
        tests.add(test2);
        implementation.append(test2);
        InstructionHandle tryStart = implementation.append((Instruction)InstructionFactory.createLoad((Type)new ObjectType(MBeanMetaData.class.getName()), (int)1));
        implementation.append((Instruction)factory.createInvoke(MBeanMetaData.class.getName(), "getMBean", (Type)Type.OBJECT, new Type[0], (short)182));
        implementation.append((Instruction)factory.createCheckCast((ReferenceType)new ObjectType(management)));
        Class<?>[] signature = method.getParameterTypes();
        Type[] invokeSignature = new Type[signature.length];
        for (int i = 0; i < signature.length; ++i) {
            Class<?> param = signature[i];
            implementation.append((Instruction)InstructionFactory.createLoad((Type)new ArrayType((Type)Type.OBJECT, 1), (int)4));
            implementation.append((CompoundInstruction)new PUSH(classGen.getConstantPool(), i));
            implementation.append((Instruction)InstructionFactory.createArrayLoad((Type)Type.OBJECT));
            invokeSignature[i] = BCELMBeanInvoker.convertClassToType(param);
            if (param.isPrimitive()) {
                BCELMBeanInvoker.replaceObjectWithPrimitive(param, implementation, factory);
                continue;
            }
            if (param.isArray()) {
                implementation.append((Instruction)factory.createCheckCast((ReferenceType)invokeSignature[i]));
                continue;
            }
            implementation.append((Instruction)factory.createCheckCast((ReferenceType)invokeSignature[i]));
        }
        Class<?> returnClass = method.getReturnType();
        Type returnType = BCELMBeanInvoker.convertClassToType(returnClass);
        implementation.append((Instruction)factory.createInvoke(management, method.getName(), returnType, invokeSignature, (short)185));
        if (returnClass == Void.TYPE) {
            implementation.append(InstructionConstants.ACONST_NULL);
        } else if (!returnClass.isArray() && returnClass.isPrimitive()) {
            BCELMBeanInvoker.replacePrimitiveWithObject(returnClass, methodGen, implementation, factory);
        }
        InstructionHandle tryEnd = implementation.append((Instruction)InstructionFactory.createReturn((Type)Type.OBJECT));
        ObjectType exceptionTypeCCE = new ObjectType("java.lang.ClassCastException");
        LocalVariableGen x = methodGen.addLocalVariable("x", (Type)exceptionTypeCCE, null, null);
        InstructionHandle handler = implementation.append((Instruction)InstructionFactory.createStore((Type)exceptionTypeCCE, (int)x.getIndex()));
        x.setStart(handler);
        x.setEnd(handler);
        methodGen.addExceptionHandler(tryStart, tryEnd, handler, exceptionTypeCCE);
        BranchInstruction skip = InstructionFactory.createBranchInstruction((short)167, null);
        catches.add(skip);
        implementation.append(skip);
        ObjectType errorTypeIAE = new ObjectType("java.lang.IllegalAccessError");
        x = methodGen.addLocalVariable("x", (Type)errorTypeIAE, null, null);
        handler = implementation.append((Instruction)InstructionFactory.createStore((Type)errorTypeIAE, (int)x.getIndex()));
        x.setStart(handler);
        x.setEnd(handler);
        methodGen.addExceptionHandler(tryStart, tryEnd, handler, errorTypeIAE);
        skip = InstructionFactory.createBranchInstruction((short)167, null);
        catches.add(skip);
        implementation.append(skip);
        return catches;
    }

    private static Type convertClassToType(Class cls) {
        if (cls == Void.TYPE) {
            return Type.VOID;
        }
        if (cls == Boolean.TYPE) {
            return Type.BOOLEAN;
        }
        if (cls == Byte.TYPE) {
            return Type.BYTE;
        }
        if (cls == Character.TYPE) {
            return Type.CHAR;
        }
        if (cls == Short.TYPE) {
            return Type.SHORT;
        }
        if (cls == Integer.TYPE) {
            return Type.INT;
        }
        if (cls == Long.TYPE) {
            return Type.LONG;
        }
        if (cls == Float.TYPE) {
            return Type.FLOAT;
        }
        if (cls == Double.TYPE) {
            return Type.DOUBLE;
        }
        if (cls == Object.class) {
            return Type.OBJECT;
        }
        if (cls == String.class) {
            return Type.STRING;
        }
        if (cls.isArray()) {
            int dimensions = 0;
            Class<?> c = null;
            while ((c = cls.getComponentType()) != null) {
                ++dimensions;
                cls = c;
            }
            Type t = BCELMBeanInvoker.convertClassToType(cls);
            return new ArrayType(t, dimensions);
        }
        return new ObjectType(cls.getName());
    }

    private static void replaceObjectWithPrimitive(Class type, InstructionList implementation, InstructionFactory factory) {
        if (type == Integer.TYPE) {
            implementation.append((Instruction)factory.createCheckCast((ReferenceType)new ObjectType(Integer.class.getName())));
            implementation.append((Instruction)factory.createInvoke(Integer.class.getName(), "intValue", (Type)Type.INT, Type.NO_ARGS, (short)182));
        } else if (type == Boolean.TYPE) {
            implementation.append((Instruction)factory.createCheckCast((ReferenceType)new ObjectType(Boolean.class.getName())));
            implementation.append((Instruction)factory.createInvoke(Boolean.class.getName(), "booleanValue", (Type)Type.BOOLEAN, Type.NO_ARGS, (short)182));
        } else if (type == Long.TYPE) {
            implementation.append((Instruction)factory.createCheckCast((ReferenceType)new ObjectType(Long.class.getName())));
            implementation.append((Instruction)factory.createInvoke(Long.class.getName(), "longValue", (Type)Type.LONG, Type.NO_ARGS, (short)182));
        } else if (type == Byte.TYPE) {
            implementation.append((Instruction)factory.createCheckCast((ReferenceType)new ObjectType(Byte.class.getName())));
            implementation.append((Instruction)factory.createInvoke(Byte.class.getName(), "byteValue", (Type)Type.BYTE, Type.NO_ARGS, (short)182));
        } else if (type == Character.TYPE) {
            implementation.append((Instruction)factory.createCheckCast((ReferenceType)new ObjectType(Character.class.getName())));
            implementation.append((Instruction)factory.createInvoke(Character.class.getName(), "charValue", (Type)Type.CHAR, Type.NO_ARGS, (short)182));
        } else if (type == Short.TYPE) {
            implementation.append((Instruction)factory.createCheckCast((ReferenceType)new ObjectType(Short.class.getName())));
            implementation.append((Instruction)factory.createInvoke(Short.class.getName(), "shortValue", (Type)Type.SHORT, Type.NO_ARGS, (short)182));
        } else if (type == Float.TYPE) {
            implementation.append((Instruction)factory.createCheckCast((ReferenceType)new ObjectType(Float.class.getName())));
            implementation.append((Instruction)factory.createInvoke(Float.class.getName(), "floatValue", (Type)Type.FLOAT, Type.NO_ARGS, (short)182));
        } else {
            implementation.append((Instruction)factory.createCheckCast((ReferenceType)new ObjectType(Double.class.getName())));
            implementation.append((Instruction)factory.createInvoke(Double.class.getName(), "doubleValue", (Type)Type.DOUBLE, Type.NO_ARGS, (short)182));
        }
    }

    private static void replacePrimitiveWithObject(Class type, MethodGen methodGen, InstructionList implementation, InstructionFactory factory) {
        if (type == Integer.TYPE) {
            LocalVariableGen i = methodGen.addLocalVariable("i", (Type)Type.INT, null, null);
            i.setStart(implementation.append((Instruction)InstructionFactory.createStore((Type)Type.INT, (int)i.getIndex())));
            implementation.append((Instruction)factory.createNew(new ObjectType(Integer.class.getName())));
            implementation.append((Instruction)InstructionConstants.DUP);
            implementation.append((Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)i.getIndex()));
            i.setEnd(implementation.append((Instruction)factory.createInvoke(Integer.class.getName(), "<init>", (Type)Type.VOID, new Type[]{Type.INT}, (short)183)));
        } else if (type == Boolean.TYPE) {
            LocalVariableGen b = methodGen.addLocalVariable("b", (Type)Type.BOOLEAN, null, null);
            b.setStart(implementation.append((Instruction)InstructionFactory.createStore((Type)Type.BOOLEAN, (int)b.getIndex())));
            implementation.append((Instruction)factory.createNew(new ObjectType(Boolean.class.getName())));
            implementation.append((Instruction)InstructionConstants.DUP);
            implementation.append((Instruction)InstructionFactory.createLoad((Type)Type.BOOLEAN, (int)b.getIndex()));
            b.setEnd(implementation.append((Instruction)factory.createInvoke(Boolean.class.getName(), "<init>", (Type)Type.VOID, new Type[]{Type.BOOLEAN}, (short)183)));
        } else if (type == Long.TYPE) {
            LocalVariableGen l = methodGen.addLocalVariable("l", (Type)Type.LONG, null, null);
            l.setStart(implementation.append((Instruction)InstructionFactory.createStore((Type)Type.LONG, (int)l.getIndex())));
            implementation.append((Instruction)factory.createNew(new ObjectType(Long.class.getName())));
            implementation.append((Instruction)InstructionConstants.DUP);
            implementation.append((Instruction)InstructionFactory.createLoad((Type)Type.LONG, (int)l.getIndex()));
            l.setEnd(implementation.append((Instruction)factory.createInvoke(Long.class.getName(), "<init>", (Type)Type.VOID, new Type[]{Type.LONG}, (short)183)));
        } else if (type == Byte.TYPE) {
            LocalVariableGen b = methodGen.addLocalVariable("b", (Type)Type.BYTE, null, null);
            b.setStart(implementation.append((Instruction)InstructionFactory.createStore((Type)Type.BYTE, (int)b.getIndex())));
            implementation.append((Instruction)factory.createNew(new ObjectType(Byte.class.getName())));
            implementation.append((Instruction)InstructionConstants.DUP);
            implementation.append((Instruction)InstructionFactory.createLoad((Type)Type.BYTE, (int)b.getIndex()));
            b.setEnd(implementation.append((Instruction)factory.createInvoke(Byte.class.getName(), "<init>", (Type)Type.VOID, new Type[]{Type.BYTE}, (short)183)));
        } else if (type == Character.TYPE) {
            LocalVariableGen c = methodGen.addLocalVariable("c", (Type)Type.CHAR, null, null);
            c.setStart(implementation.append((Instruction)InstructionFactory.createStore((Type)Type.CHAR, (int)c.getIndex())));
            implementation.append((Instruction)factory.createNew(new ObjectType(Character.class.getName())));
            implementation.append((Instruction)InstructionConstants.DUP);
            implementation.append((Instruction)InstructionFactory.createLoad((Type)Type.CHAR, (int)c.getIndex()));
            c.setEnd(implementation.append((Instruction)factory.createInvoke(Character.class.getName(), "<init>", (Type)Type.VOID, new Type[]{Type.CHAR}, (short)183)));
        } else if (type == Short.TYPE) {
            LocalVariableGen s = methodGen.addLocalVariable("s", (Type)Type.SHORT, null, null);
            s.setStart(implementation.append((Instruction)InstructionFactory.createStore((Type)Type.SHORT, (int)s.getIndex())));
            implementation.append((Instruction)factory.createNew(new ObjectType(Short.class.getName())));
            implementation.append((Instruction)InstructionConstants.DUP);
            implementation.append((Instruction)InstructionFactory.createLoad((Type)Type.SHORT, (int)s.getIndex()));
            s.setEnd(implementation.append((Instruction)factory.createInvoke(Short.class.getName(), "<init>", (Type)Type.VOID, new Type[]{Type.SHORT}, (short)183)));
        } else if (type == Float.TYPE) {
            LocalVariableGen f = methodGen.addLocalVariable("f", (Type)Type.FLOAT, null, null);
            f.setStart(implementation.append((Instruction)InstructionFactory.createStore((Type)Type.FLOAT, (int)f.getIndex())));
            implementation.append((Instruction)factory.createNew(new ObjectType(Float.class.getName())));
            implementation.append((Instruction)InstructionConstants.DUP);
            implementation.append((Instruction)InstructionFactory.createLoad((Type)Type.FLOAT, (int)f.getIndex()));
            f.setEnd(implementation.append((Instruction)factory.createInvoke(Float.class.getName(), "<init>", (Type)Type.VOID, new Type[]{Type.FLOAT}, (short)183)));
        } else {
            LocalVariableGen d = methodGen.addLocalVariable("d", (Type)Type.DOUBLE, null, null);
            d.setStart(implementation.append((Instruction)InstructionFactory.createStore((Type)Type.DOUBLE, (int)d.getIndex())));
            implementation.append((Instruction)factory.createNew(new ObjectType(Double.class.getName())));
            implementation.append((Instruction)InstructionConstants.DUP);
            implementation.append((Instruction)InstructionFactory.createLoad((Type)Type.DOUBLE, (int)d.getIndex()));
            d.setEnd(implementation.append((Instruction)factory.createInvoke(Double.class.getName(), "<init>", (Type)Type.VOID, new Type[]{Type.DOUBLE}, (short)183)));
        }
    }

    private Logger getLogger() {
        return Log.getLogger(LOGGER_CATEGORY);
    }

    @Override
    protected Object invokeImpl(MBeanMetaData metadata, String method, String[] signature, Object[] args) throws Throwable {
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info("BCEL invocation failed for method " + method + "" + Arrays.asList(signature) + ", using reflection");
        }
        return super.invokeImpl(metadata, method, signature, args);
    }

    private static class BCELClassLoader
    extends SecureClassLoader {
        private byte[] m_bytes;

        private BCELClassLoader(ClassLoader parent, byte[] bytecode) {
            super(parent);
            this.m_bytes = bytecode;
        }

        protected Class findClass(final String name) throws ClassNotFoundException {
            try {
                return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException {
                        try {
                            return BCELClassLoader.this.defineClass(name, BCELClassLoader.this.m_bytes, 0, BCELClassLoader.this.m_bytes.length, BCELClassLoader.this.getClass().getProtectionDomain());
                        }
                        catch (ClassFormatError x) {
                            throw new ClassNotFoundException("Class Format Error", x);
                        }
                    }
                }, null);
            }
            catch (PrivilegedActionException x) {
                throw (ClassNotFoundException)x.getException();
            }
        }
    }
}

