/*
 * Decompiled with CFR 0.152.
 */
package mx4j.server.interceptor;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import mx4j.ImplementationException;
import mx4j.log.Logger;
import mx4j.server.MBeanMetaData;
import mx4j.server.interceptor.DefaultMBeanServerInterceptor;
import mx4j.server.interceptor.InvokerMBeanServerInterceptorMBean;
import mx4j.util.Utils;

public class InvokerMBeanServerInterceptor
extends DefaultMBeanServerInterceptor
implements InvokerMBeanServerInterceptorMBean {
    private MBeanServer outerServer;

    public InvokerMBeanServerInterceptor(MBeanServer outerServer) {
        this.outerServer = outerServer;
    }

    @Override
    public String getType() {
        return "invoker";
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void addNotificationListener(MBeanMetaData metadata, NotificationListener listener, NotificationFilter filter, Object handback) {
        ((NotificationBroadcaster)metadata.getMBean()).addNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(MBeanMetaData metadata, NotificationListener listener) throws ListenerNotFoundException {
        ((NotificationBroadcaster)metadata.getMBean()).removeNotificationListener(listener);
    }

    @Override
    public void removeNotificationListener(MBeanMetaData metadata, NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        ((NotificationEmitter)metadata.getMBean()).removeNotificationListener(listener, filter, handback);
    }

    @Override
    public void instantiate(MBeanMetaData metadata, String className, String[] params, Object[] args) throws ReflectionException, MBeanException {
        try {
            ClassLoader loader = metadata.getClassLoader();
            if (loader == null) {
                loader = Thread.currentThread().getContextClassLoader();
            }
            Class<?> cls = loader.loadClass(className);
            Class[] signature = Utils.loadClasses(loader, params);
            Constructor<?> ctor = cls.getConstructor(signature);
            metadata.setMBean(ctor.newInstance(args));
        }
        catch (ClassNotFoundException x) {
            throw new ReflectionException(x);
        }
        catch (NoSuchMethodException x) {
            throw new ReflectionException(x);
        }
        catch (InstantiationException x) {
            throw new ReflectionException(x);
        }
        catch (IllegalAccessException x) {
            throw new ReflectionException(x);
        }
        catch (IllegalArgumentException x) {
            throw new ReflectionException(x);
        }
        catch (InvocationTargetException x) {
            Throwable t = x.getTargetException();
            if (t instanceof Error) {
                throw new RuntimeErrorException((Error)t);
            }
            if (t instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)t);
            }
            throw new MBeanException((Exception)t);
        }
    }

    @Override
    public void registration(MBeanMetaData metadata, int operation) throws MBeanRegistrationException {
        Object mbean = metadata.getMBean();
        if (!(mbean instanceof MBeanRegistration)) {
            return;
        }
        MBeanRegistration registrable = (MBeanRegistration)mbean;
        try {
            switch (operation) {
                case 1: {
                    ObjectName objName = registrable.preRegister(this.outerServer, metadata.getObjectName());
                    metadata.setObjectName(objName);
                    break;
                }
                case 2: {
                    registrable.postRegister(Boolean.TRUE);
                    break;
                }
                case 3: {
                    registrable.postRegister(Boolean.FALSE);
                    break;
                }
                case 4: {
                    registrable.preDeregister();
                    break;
                }
                case 5: {
                    registrable.postDeregister();
                    break;
                }
                default: {
                    throw new ImplementationException();
                }
            }
        }
        catch (RuntimeException x) {
            throw new RuntimeMBeanException(x);
        }
        catch (Exception x) {
            if (x instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)x;
            }
            throw new MBeanRegistrationException(x);
        }
        catch (Error x) {
            throw new RuntimeErrorException(x);
        }
    }

    @Override
    public MBeanInfo getMBeanInfo(MBeanMetaData metadata) {
        if (metadata.isMBeanDynamic()) {
            MBeanInfo info = null;
            try {
                info = ((DynamicMBean)metadata.getMBean()).getMBeanInfo();
            }
            catch (RuntimeException x) {
                throw new RuntimeMBeanException(x);
            }
            if (info == null) {
                return null;
            }
            metadata.setMBeanInfo(info);
        }
        return (MBeanInfo)metadata.getMBeanInfo().clone();
    }

    @Override
    public Object invoke(MBeanMetaData metadata, String method, String[] params, Object[] args) throws MBeanException, ReflectionException {
        if (metadata.isMBeanDynamic()) {
            try {
                return ((DynamicMBean)metadata.getMBean()).invoke(method, args, params);
            }
            catch (JMRuntimeException x) {
                throw x;
            }
            catch (RuntimeException x) {
                throw new RuntimeMBeanException(x);
            }
            catch (Error x) {
                throw new RuntimeErrorException(x);
            }
        }
        return metadata.getMBeanInvoker().invoke(metadata, method, params, args);
    }

    @Override
    public Object getAttribute(MBeanMetaData metadata, String attribute) throws MBeanException, AttributeNotFoundException, ReflectionException {
        if (metadata.isMBeanDynamic()) {
            try {
                return ((DynamicMBean)metadata.getMBean()).getAttribute(attribute);
            }
            catch (JMRuntimeException x) {
                throw x;
            }
            catch (RuntimeException x) {
                throw new RuntimeMBeanException(x);
            }
            catch (Error x) {
                throw new RuntimeErrorException(x);
            }
        }
        return metadata.getMBeanInvoker().getAttribute(metadata, attribute);
    }

    @Override
    public void setAttribute(MBeanMetaData metadata, Attribute attribute) throws MBeanException, AttributeNotFoundException, InvalidAttributeValueException, ReflectionException {
        if (metadata.isMBeanDynamic()) {
            try {
                ((DynamicMBean)metadata.getMBean()).setAttribute(attribute);
            }
            catch (JMRuntimeException x) {
                throw x;
            }
            catch (RuntimeException x) {
                throw new RuntimeMBeanException(x);
            }
            catch (Error x) {
                throw new RuntimeErrorException(x);
            }
        } else {
            metadata.getMBeanInvoker().setAttribute(metadata, attribute);
        }
    }

    @Override
    public AttributeList getAttributes(MBeanMetaData metadata, String[] attributes) {
        if (metadata.isMBeanDynamic()) {
            try {
                return ((DynamicMBean)metadata.getMBean()).getAttributes(attributes);
            }
            catch (JMRuntimeException x) {
                throw x;
            }
            catch (RuntimeException x) {
                throw new RuntimeMBeanException(x);
            }
            catch (Error x) {
                throw new RuntimeErrorException(x);
            }
        }
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributes.length; ++i) {
            String name = attributes[i];
            try {
                Object value = this.getAttribute(metadata, name);
                Attribute attr = new Attribute(name, value);
                list.add(attr);
                continue;
            }
            catch (Exception ignored) {
                Logger logger = this.getLogger();
                if (!logger.isEnabledFor(10)) continue;
                logger.debug("Exception caught from getAttributes(), ignoring attribute " + name);
            }
        }
        return list;
    }

    @Override
    public AttributeList setAttributes(MBeanMetaData metadata, AttributeList attributes) {
        if (metadata.isMBeanDynamic()) {
            try {
                return ((DynamicMBean)metadata.getMBean()).setAttributes(attributes);
            }
            catch (JMRuntimeException x) {
                throw x;
            }
            catch (RuntimeException x) {
                throw new RuntimeMBeanException(x);
            }
            catch (Error x) {
                throw new RuntimeErrorException(x);
            }
        }
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributes.size(); ++i) {
            Attribute attr = (Attribute)attributes.get(i);
            try {
                this.setAttribute(metadata, attr);
                list.add(attr);
                continue;
            }
            catch (Exception ignored) {
                Logger logger = this.getLogger();
                if (!logger.isEnabledFor(10)) continue;
                logger.debug("Exception caught from setAttributes(), ignoring attribute " + attr, ignored);
            }
        }
        return list;
    }
}

