/*
 * Decompiled with CFR 0.152.
 */
package mx4j.server.interceptor;

import java.util.ArrayList;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import mx4j.ImplementationException;
import mx4j.server.interceptor.MBeanServerInterceptor;
import mx4j.server.interceptor.MBeanServerInterceptorConfiguratorMBean;

public class MBeanServerInterceptorConfigurator
implements MBeanServerInterceptorConfiguratorMBean {
    public static final String OBJECT_NAME = "JMImplementation:type=MBeanServerInterceptorConfigurator";
    private final MBeanServer server;
    private final ArrayList preInterceptors = new ArrayList();
    private final ArrayList postInterceptors = new ArrayList();
    private final ArrayList clientInterceptors = new ArrayList();
    private volatile boolean running;
    private boolean chainModified;
    private MBeanServerInterceptor head;

    public MBeanServerInterceptorConfigurator(MBeanServer server) {
        this.server = server;
        this.chainModified = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInterceptor(MBeanServerInterceptor interceptor) {
        ArrayList arrayList = this.clientInterceptors;
        synchronized (arrayList) {
            this.clientInterceptors.add(interceptor);
            this.chainModified = true;
        }
    }

    @Override
    public void registerInterceptor(MBeanServerInterceptor interceptor, ObjectName name) throws MBeanException {
        try {
            this.server.registerMBean(interceptor, name);
            this.addInterceptor(interceptor);
        }
        catch (Exception x) {
            throw new MBeanException(x, "Could not register interceptor with name " + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearInterceptors() {
        ArrayList arrayList = this.clientInterceptors;
        synchronized (arrayList) {
            this.clientInterceptors.clear();
            this.chainModified = true;
        }
    }

    public void addPreInterceptor(MBeanServerInterceptor interceptor) {
        if (this.isRunning()) {
            throw new ImplementationException();
        }
        this.preInterceptors.add(interceptor);
    }

    public void addPostInterceptor(MBeanServerInterceptor interceptor) {
        if (this.isRunning()) {
            throw new ImplementationException();
        }
        this.postInterceptors.add(interceptor);
    }

    public MBeanServerInterceptor getHeadInterceptor() {
        if (!this.isRunning()) {
            return null;
        }
        if (this.chainModified) {
            this.setupChain();
        }
        return this.head;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupChain() {
        this.chainModified = false;
        int size = this.clientInterceptors.size();
        ArrayList chain = new ArrayList(this.preInterceptors.size() + size + this.postInterceptors.size());
        chain.addAll(this.preInterceptors);
        if (size > 0) {
            ArrayList arrayList = this.clientInterceptors;
            synchronized (arrayList) {
                chain.addAll(this.clientInterceptors);
            }
        }
        chain.addAll(this.postInterceptors);
        MBeanServerInterceptor first = (MBeanServerInterceptor)chain.get(0);
        first.setChain(chain);
        this.head = first;
    }

    @Override
    public void start() {
        if (!this.isRunning()) {
            this.running = true;
        }
    }

    @Override
    public void stop() {
        if (this.isRunning()) {
            this.running = false;
        }
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }
}

