/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.adaptor.http;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import javax.management.JMException;
import javax.management.loading.DefaultLoaderRepository;
import mx4j.tools.adaptor.http.CommandProcessorUtil;
import mx4j.tools.adaptor.http.HttpCommandProcessorAdaptor;
import mx4j.tools.adaptor.http.HttpInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConstructorsCommandProcessor
extends HttpCommandProcessorAdaptor {
    @Override
    public Document executeRequest(HttpInputStream in) throws IOException, JMException {
        Document document = this.builder.newDocument();
        String classname = in.getVariable("classname");
        if (classname == null || classname.trim().length() == 0) {
            return this.createException(document, "", "classname parameter required");
        }
        Class<?> targetClass = null;
        try {
            targetClass = DefaultLoaderRepository.loadClass(classname);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            if (targetClass == null) {
                targetClass = ClassLoader.getSystemClassLoader().loadClass(classname);
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            if (targetClass == null) {
                targetClass = this.getClass().getClassLoader().loadClass(classname);
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (targetClass == null) {
            return this.createException(document, classname, "class " + classname + " not found");
        }
        Element root = document.createElement("Class");
        root.setAttribute("classname", classname);
        document.appendChild(root);
        Constructor<?>[] constructors = targetClass.getConstructors();
        Arrays.sort(constructors, CommandProcessorUtil.createConstructorComparator());
        for (int i = 0; i < constructors.length; ++i) {
            System.out.println("Constructor " + constructors[i]);
            Element constructor = document.createElement("Constructor");
            constructor.setAttribute("name", constructors[i].getName());
            this.addParameters(constructor, document, constructors[i].getParameterTypes());
            root.appendChild(constructor);
        }
        return document;
    }

    protected void addParameters(Element node, Document document, Class[] parameters) {
        for (int j = 0; j < parameters.length; ++j) {
            Element parameter = document.createElement("Parameter");
            parameter.setAttribute("type", parameters[j].getName());
            parameter.setAttribute("strinit", String.valueOf(CommandProcessorUtil.canCreateParameterValue(parameters[j].getName())));
            parameter.setAttribute("id", "" + j);
            node.appendChild(parameter);
        }
    }

    private Document createException(Document document, String classname, String message) {
        Element exceptionElement = document.createElement("Exception");
        document.appendChild(exceptionElement);
        exceptionElement.setAttribute("classname", classname);
        exceptionElement.setAttribute("errorMsg", message);
        return document;
    }
}

