/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.adaptor.http;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.relation.RelationServiceMBean;
import javax.management.relation.RoleInfo;
import mx4j.tools.adaptor.http.HttpCommandProcessorAdaptor;
import mx4j.tools.adaptor.http.HttpInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class RelationCommandProcessor
extends HttpCommandProcessorAdaptor {
    private ObjectName m_relationObjectName = null;
    private RelationServiceMBean m_proxy = null;

    @Override
    public Document executeRequest(HttpInputStream in) throws IOException, JMException {
        Document document = this.builder.newDocument();
        Element root = document.createElement("RelationServer");
        document.appendChild(root);
        if (!this.checkRelationServiceIsRegistered()) {
            Element defaultElement = document.createElement("default");
            Text defaultNode = document.createTextNode("RelationService is not registered!");
            defaultElement.appendChild(defaultNode);
            root.appendChild(defaultElement);
            return document;
        }
        this.m_proxy = MBeanServerInvocationHandler.newProxyInstance(this.server, this.m_relationObjectName, RelationServiceMBean.class, true);
        List<String> allRelationNames = this.m_proxy.getAllRelationTypeNames();
        this.addRelationTypeNames(root, document, allRelationNames);
        return document;
    }

    protected void addRelationTypeNames(Element node, Document document, List allRelationNames) throws JMException {
        HashMap<String, List<String>> namesMap = new HashMap<String, List<String>>();
        for (String name : allRelationNames) {
            List<String> values = this.m_proxy.findRelationsOfType(name);
            if (namesMap.containsKey(name)) {
                ((List)namesMap.get(name)).add(values);
                continue;
            }
            namesMap.put(name, values);
        }
        for (String relationName : namesMap.keySet()) {
            Element typeNameElement = document.createElement("relation-type-name");
            typeNameElement.setAttribute("name", relationName);
            node.appendChild(typeNameElement);
            List<RoleInfo> infos = this.m_proxy.getRoleInfos(relationName);
            for (RoleInfo roleInfo : infos) {
                String roleName = roleInfo.getName();
                String mbeanClassName = roleInfo.getRefMBeanClassName();
                String description = roleInfo.getDescription();
                int minDegree = roleInfo.getMinDegree();
                int maxDegree = roleInfo.getMaxDegree();
                boolean reading = roleInfo.isReadable();
                boolean writing = roleInfo.isWritable();
                Element roleInfoElement = document.createElement("relation-meta-data");
                Element roleNameElement = document.createElement("role-name");
                Text roleNameNode = document.createTextNode(roleName);
                roleNameElement.appendChild(roleNameNode);
                roleInfoElement.appendChild(roleNameElement);
                Element mbeanClassElement = document.createElement("mbean-classname");
                Text mbeanClassNode = document.createTextNode(mbeanClassName);
                mbeanClassElement.appendChild(mbeanClassNode);
                roleInfoElement.appendChild(mbeanClassElement);
                Element descriptionElement = document.createElement("description");
                if (description == null) {
                    description = "no description";
                }
                Text descriptionNode = document.createTextNode(description);
                descriptionElement.appendChild(descriptionNode);
                roleInfoElement.appendChild(descriptionElement);
                Element minDegreeElement = document.createElement("min-degree");
                Text minDegreeNode = document.createTextNode(Integer.toString(minDegree));
                minDegreeElement.appendChild(minDegreeNode);
                roleInfoElement.appendChild(minDegreeElement);
                Element maxDegreeElement = document.createElement("max-degree");
                Text maxDegreeNode = document.createTextNode(Integer.toString(maxDegree));
                maxDegreeElement.appendChild(maxDegreeNode);
                roleInfoElement.appendChild(maxDegreeElement);
                Element readingElement = document.createElement("is-readable");
                String readable = null;
                readable = reading ? "true" : "false";
                Text readingNode = document.createTextNode(readable);
                readingElement.appendChild(readingNode);
                roleInfoElement.appendChild(readingElement);
                Element writingElement = document.createElement("is-writable");
                String writable = null;
                writable = writing ? "true" : "false";
                Text writingNode = document.createTextNode(writable);
                writingElement.appendChild(writingNode);
                roleInfoElement.appendChild(writingElement);
                typeNameElement.appendChild(roleInfoElement);
            }
            List references = (List)namesMap.get(relationName);
            for (String relationId : references) {
                Element idElement = document.createElement("relation-id");
                Text idNode = document.createTextNode(relationId);
                idElement.appendChild(idNode);
                typeNameElement.appendChild(idElement);
            }
        }
    }

    protected boolean checkRelationServiceIsRegistered() {
        Set<ObjectInstance> allMBeans = this.server.queryMBeans(null, null);
        for (ObjectInstance instance : allMBeans) {
            if (!instance.getClassName().equals("javax.management.relation.RelationService")) continue;
            this.m_relationObjectName = instance.getObjectName();
            return true;
        }
        return false;
    }
}

