/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.remote.http;

import java.io.IOException;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import mx4j.remote.NotificationTuple;
import mx4j.remote.RemoteNotificationClientHandler;
import mx4j.tools.remote.JMXConnection;
import mx4j.tools.remote.JMXConnectionMBeanServerConnection;
import mx4j.tools.remote.http.HTTPConnection;

public class HTTPConnectionMBeanServerConnection
extends JMXConnectionMBeanServerConnection {
    private final RemoteNotificationClientHandler notificationHandler;

    public HTTPConnectionMBeanServerConnection(JMXConnection connection, Subject delegate, RemoteNotificationClientHandler notificationHandler) {
        super(connection, delegate);
        this.notificationHandler = notificationHandler;
    }

    @Override
    public void addNotificationListener(ObjectName observed, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        NotificationTuple tuple = new NotificationTuple(observed, listener, filter, handback);
        tuple.setInvokeFilter(true);
        if (this.notificationHandler.contains(tuple)) {
            return;
        }
        Integer id = ((HTTPConnection)this.getConnection()).addNotificationListener(observed, null, this.getDelegateSubject());
        this.notificationHandler.addNotificationListener(id, tuple);
    }

    @Override
    public void removeNotificationListener(ObjectName observed, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        Integer[] ids = this.notificationHandler.getNotificationListeners(new NotificationTuple(observed, listener));
        if (ids == null) {
            throw new ListenerNotFoundException("Could not find listener " + listener);
        }
        ((HTTPConnection)this.getConnection()).removeNotificationListeners(observed, ids, this.getDelegateSubject());
        this.notificationHandler.removeNotificationListeners(ids);
    }

    @Override
    public void removeNotificationListener(ObjectName observed, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        Integer id = this.notificationHandler.getNotificationListener(new NotificationTuple(observed, listener, filter, handback));
        if (id == null) {
            throw new ListenerNotFoundException("Could not find listener " + listener + " with filter " + filter + " and handback " + handback);
        }
        Integer[] ids = new Integer[]{id};
        ((HTTPConnection)this.getConnection()).removeNotificationListeners(observed, ids, this.getDelegateSubject());
        this.notificationHandler.removeNotificationListeners(ids);
    }
}

