/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.remote.http;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.remote.JMXServiceURL;
import mx4j.remote.ConnectionResolver;
import mx4j.tools.remote.http.WebContainer;

public abstract class HTTPResolver
extends ConnectionResolver {
    protected static final String DEFAULT_WEB_CONTAINER_CLASS = "mx4j.tools.remote.http.jetty.JettyWebContainer";
    private static Map webContainers = new HashMap();
    private static Map deployedURLs = new HashMap();
    private static final WebContainer EXTERNAL_WEB_CONTAINER = new ExternalWebContainer();

    @Override
    public Object bindClient(Object client, Map environment) throws IOException {
        return client;
    }

    protected String getEndpoint(JMXServiceURL address, Map environment) {
        String transport = this.getEndpointProtocol(environment);
        return transport + this.getEndpointPath(address);
    }

    protected String getEndpointProtocol(Map environment) {
        return "http";
    }

    private String getEndpointPath(JMXServiceURL url) {
        String address = url.toString();
        String prefix = "service:jmx:" + url.getProtocol();
        return address.substring(prefix.length());
    }

    @Override
    public Object createServer(JMXServiceURL url, Map environment) throws IOException {
        boolean useExternalWebContainer;
        WebContainer result = null;
        boolean bl = useExternalWebContainer = environment == null ? false : Boolean.valueOf(String.valueOf(environment.get("jmx.remote.x.http.use.external.web.container")));
        if (!useExternalWebContainer) {
            String webContainerClassName;
            String string = webContainerClassName = environment == null ? null : (String)environment.get("jmx.remote.x.http.embedded.web.container.class");
            if (webContainerClassName == null || webContainerClassName.length() == 0) {
                webContainerClassName = DEFAULT_WEB_CONTAINER_CLASS;
            }
            if ((result = this.findWebContainer(url, webContainerClassName)) == null && (result = this.createWebContainer(url, webContainerClassName, environment)) != null) {
                result.start(url, environment);
            }
            if (result == null) {
                throw new IOException("Could not start embedded web container");
            }
        }
        return result;
    }

    private WebContainer findWebContainer(JMXServiceURL url, String webContainerClassName) {
        String key = this.createWebContainerKey(url, webContainerClassName);
        return (WebContainer)webContainers.get(key);
    }

    private String createWebContainerKey(JMXServiceURL url, String webContainerClassName) {
        return new StringBuffer(webContainerClassName).append("|").append(url.getHost()).append("|").append(url.getPort()).toString();
    }

    @Override
    public JMXServiceURL bindServer(Object server, JMXServiceURL url, Map environment) throws IOException {
        WebContainer webContainer = (WebContainer)server;
        if (!this.isDeployed(webContainer, url)) {
            if (webContainer != null) {
                webContainer.deploy(this.getServletClassName(), url, environment);
            }
            if (!this.hasDeployed(webContainer)) {
                this.deploy(url, environment);
            }
            this.addDeployed(webContainer, url);
        }
        return url;
    }

    protected abstract String getServletClassName();

    protected void deploy(JMXServiceURL address, Map environment) throws IOException {
    }

    @Override
    public void unbindServer(Object server, JMXServiceURL address, Map environment) throws IOException {
        WebContainer webContainer = (WebContainer)server;
        if (this.isDeployed(webContainer, address)) {
            this.removeDeployed(webContainer, address);
            if (!this.hasDeployed(webContainer)) {
                this.undeploy(address, environment);
            }
            if (webContainer != null) {
                webContainer.undeploy(this.getServletClassName(), address, environment);
            }
        }
    }

    protected void undeploy(JMXServiceURL address, Map environment) throws IOException {
    }

    @Override
    public void destroyServer(Object server, JMXServiceURL url, Map environment) throws IOException {
        WebContainer webContainer = (WebContainer)server;
        if (webContainer != null && !this.hasDeployed(webContainer)) {
            String key = this.createWebContainerKey(url, server.getClass().getName());
            WebContainer container = (WebContainer)webContainers.remove(key);
            if (webContainer != container) {
                throw new IOException("Trying to stop the wrong web container: " + server + " should be: " + container);
            }
            webContainer.stop();
        }
    }

    protected WebContainer createWebContainer(JMXServiceURL url, String webContainerClassName, Map environment) {
        Object cl;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (environment != null && (cl = environment.get("jmx.remote.protocol.provider.class.loader")) instanceof ClassLoader) {
            loader = (ClassLoader)cl;
        }
        try {
            WebContainer webContainer = (WebContainer)loader.loadClass(webContainerClassName).newInstance();
            String key = this.createWebContainerKey(url, webContainerClassName);
            webContainers.put(key, webContainer);
            return webContainer;
        }
        catch (Exception x) {
            return null;
        }
    }

    private boolean isDeployed(WebContainer webContainer, JMXServiceURL url) {
        Set urls;
        if (webContainer == null) {
            webContainer = EXTERNAL_WEB_CONTAINER;
        }
        if ((urls = (Set)deployedURLs.get(webContainer)) == null) {
            return false;
        }
        return urls.contains(url);
    }

    private boolean hasDeployed(WebContainer webContainer) {
        Set urls;
        if (webContainer == null) {
            webContainer = EXTERNAL_WEB_CONTAINER;
        }
        if ((urls = (Set)deployedURLs.get(webContainer)) == null) {
            return false;
        }
        return !urls.isEmpty();
    }

    private void addDeployed(WebContainer webContainer, JMXServiceURL url) {
        HashSet<JMXServiceURL> urls;
        if (webContainer == null) {
            webContainer = EXTERNAL_WEB_CONTAINER;
        }
        if ((urls = (HashSet<JMXServiceURL>)deployedURLs.get(webContainer)) == null) {
            urls = new HashSet<JMXServiceURL>();
            deployedURLs.put(webContainer, urls);
        }
        urls.add(url);
    }

    private void removeDeployed(WebContainer webContainer, JMXServiceURL url) {
        Set urls;
        if (webContainer == null) {
            webContainer = EXTERNAL_WEB_CONTAINER;
        }
        if ((urls = (Set)deployedURLs.get(webContainer)) != null) {
            urls.remove(url);
            if (urls.isEmpty()) {
                deployedURLs.remove(webContainer);
            }
        }
    }

    private static class ExternalWebContainer
    implements WebContainer {
        private ExternalWebContainer() {
        }

        @Override
        public void start(JMXServiceURL url, Map environment) throws IOException {
        }

        @Override
        public void stop() throws IOException {
        }

        @Override
        public void deploy(String servletClassName, JMXServiceURL url, Map environment) throws IOException {
        }

        @Override
        public void undeploy(String servletClassName, JMXServiceURL url, Map environment) {
        }

        public String toString() {
            return "External WebContainer";
        }
    }
}

